#!/usr/bin/env python
# _*_ coding: iso-8859-1 _*_

import logging
import traceback
import os
import _winreg
from lance_cmd import lancecmd
from os_type import type_os
import win32_64


from time import sleep


###############################################
## Actions sur le menu dmarrer et le bureau ##
###############################################
def load_default_menus():
    hkey = 'HKEY_LOCAL_MACHINE'
    kpath = r'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders'
    kpath2 = r'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders'
    if type_os == 'Vista':
        PUBLIC = os.environ['PUBLIC']
        PROGRAMDATA = os.environ['ProgramData']
        # Shell Folders
        addreg(hkey, kpath, 'REG_SZ', 'Common AppData', r'%s\Application Data'%PROGRAMDATA)
        addreg(hkey, kpath, 'REG_SZ', 'Common Desktop', r'%s\Desktop'%PUBLIC)
        addreg(hkey, kpath, 'REG_SZ', 'Common Documents', r'%s\Documents'%PUBLIC)
        addreg(hkey, kpath, 'REG_SZ', 'Common Programs', r'%s\Microsoft\Windows\Start Menu\Programs'%PROGRAMDATA)
        addreg(hkey, kpath, 'REG_SZ', 'Common Start Menu', r'%s\Microsoft\Windows\Start Menu'%PROGRAMDATA)
        addreg(hkey, kpath, 'REG_SZ', 'Common Startup', r'%s\Microsoft\Windows\Start Menu\StartUp'%PROGRAMDATA)
        addreg(hkey, kpath, 'REG_SZ', 'Common Templates', r'%s\Microsoft\Windows\Templates'%PROGRAMDATA)
        addreg(hkey, kpath, 'REG_SZ', 'CommonMusic', r'%s\Music'%PUBLIC)
        addreg(hkey, kpath, 'REG_SZ', 'CommonPictures', r'%s\Pictures'%PUBLIC)
        addreg(hkey, kpath, 'REG_SZ', 'CommonVideo', r'%s\Videos'%PUBLIC)
        # User Shell Folders
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common AppData', r'%ProgramData%\Application Data')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Desktop', r'%PUBLIC%\Desktop')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Documents', r'%PUBLIC%\Documents')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Programs', r'%ProgramData%\Microsoft\Windows\Start Menu\Programs')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Start Menu', r'%ProgramData%\Microsoft\Windows\Start Menu')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Startup', r'%ProgramData%\Microsoft\Windows\Start Menu\Programs\StartUp')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Templates', r'%ProgramData%\Microsoft\Windows\Templates')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'CommonMusic', r'%PUBLIC%\Music')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'CommonPictures', r'%PUBLIC%\Pictures')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'CommonVideo', r'%PUBLIC%\Videos')
    elif type_os in ['WinXP', 'Win2K', 'Win2k3', 'WinNT']:
        ALLUSERSPROFILE = os.environ['ALLUSERSPROFILE']
        # Shell Folders
        addreg(hkey, kpath, 'REG_SZ', 'Common AppData', r'%s\Application Data'%ALLUSERSPROFILE)
        addreg(hkey, kpath, 'REG_SZ', 'Common Desktop', r'%s\Bureau'%ALLUSERSPROFILE)
        addreg(hkey, kpath, 'REG_SZ', 'Common Documents', r'%s\Documents'%ALLUSERSPROFILE)
        addreg(hkey, kpath, 'REG_SZ', 'Common Programs', r'%s\Menu Dmarrer\Programmes'%ALLUSERSPROFILE)
        addreg(hkey, kpath, 'REG_SZ', 'Common Start Menu', r'%s\Menu Dmarrer'%ALLUSERSPROFILE)
        addreg(hkey, kpath, 'REG_SZ', 'Common Startup', r'%s\Menu Dmarrer\Programmes\Dmarrage'%ALLUSERSPROFILE)
        addreg(hkey, kpath, 'REG_SZ', 'Common Templates', r'%s\Modles'%ALLUSERSPROFILE)
        addreg(hkey, kpath, 'REG_SZ', 'CommonMusic', r'%s\Documents\Ma musique'%ALLUSERSPROFILE)
        addreg(hkey, kpath, 'REG_SZ', 'CommonPictures', r'%s\Documents\Mes images'%ALLUSERSPROFILE)
        addreg(hkey, kpath, 'REG_SZ', 'CommonVideo', r'%s\Documents\Mes vidos'%ALLUSERSPROFILE)
        # User Shell Folders
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common AppData', r'%ALLUSERSPROFILE%\Application Data')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Desktop', r'%ALLUSERSPROFILE%\Bureau')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Documents', r'%ALLUSERSPROFILE%\Documents')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Programs', r'%ALLUSERSPROFILE%\Menu Dmarrer\Programmes')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Start Menu', r'%ALLUSERSPROFILE%\Menu Dmarrer')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Startup', r'%ALLUSERSPROFILE%\Menu Dmarrer\Programmes\Dmarrage')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'Common Templates', r'%ALLUSERSPROFILE%\Modles')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'CommonMusic', r'%ALLUSERSPROFILE%\Ma musique')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'CommonPictures', r'%ALLUSERSPROFILE%\Mes images')
        addreg(hkey, kpath2, 'REG_EXPAND_SZ', 'CommonVideo', r'%ALLUSERSPROFILE%\Mes vidos')

def save_menus(tmpdir):
    """sauve les redirection des dossiers (Menu dmarrer, Bureau, Application Data, etc.)
    """
    key = r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders'
    key2 = r'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders'
    fich = os.path.join(tmpdir, 'menu1.reg')
    fich2 = os.path.join(tmpdir, 'menu2.reg')
    save_reg(key, fich)
    save_reg(key2, fich2)

def save_reg(keypath, fich):
    """Sauve keypath dans un fichier <fich> .reg
    """
    cmd = 'regedit /e "%s" "%s"'%(fich, keypath)
    try:
        with win32_64.disable_file_system_redirection():
            lancecmd(cmd, hide=True)
    except Exception, e:
        logging.error('%s'%e)
    
def load_menus(tmpdir):
    """recharge les redirections de dossiers sauvegard par save_menus
    """
    fich = os.path.join(tmpdir, 'menu1.reg')
    fich2 = os.path.join(tmpdir, 'menu2.reg')
    load_reg(fich)
    load_reg(fich2)
##    os.unlink(fich) # wa.WinExec n'attend pas, donc ne pas effacer le fichier avant qu'il ne soit utilis ...
##    os.unlink(fich2) # wa.WinExec n'attend pas, donc ne pas effacer le fichier avant qu'il ne soit utilis ...
    return True

def load_reg(fich):
    cmd = 'regedit /s "%s"'%(fich)
    try:
        with win32_64.disable_file_system_redirection():
            lancecmd(cmd, hide=True)
    except Exception, e:
        logging.error('%s'%e)

#############################################################
## Ajouter / Supprimer des lments de la base de registre ##
#############################################################
def gethkey(hkey):
    """permet des raccourcis
    """
    if hkey == 'HKLM': hkey = 'HKEY_LOCAL_MACHINE'
    if hkey == 'HKCU': hkey = 'HKEY_CURRENT_USER'
    if hkey == 'HKU': hkey = 'HKEY_USERS'
    if type(hkey) == str or type(hkey) == unicode: hkey = getattr(_winreg, hkey)
    return hkey

def delreg(hkey, path, name):
    """Supprime la valeur name dans path
    """
    hkey = gethkey(hkey)
    try:
        k = _winreg.OpenKey(hkey, path, 0, _winreg.KEY_ALL_ACCESS | win32_64.KEY_WOW64_64KEY)
        _winreg.DeleteValue(k, name)
    except WindowsError: pass
    try: k.Close()
    except: pass
    

def addreg(hkey, kpath, ktype, kname, kval):
    """renseigne hkey\path name(type)=value dans la base de registre
    hkey = handle d'une cl ouverte
    """
    hkey = gethkey(hkey)
    _winreg.CreateKeyEx(hkey, kpath, 0, _winreg.KEY_ALL_ACCESS | win32_64.KEY_WOW64_64KEY)
    k = _winreg.OpenKeyEx(hkey, kpath, 0, _winreg.KEY_ALL_ACCESS | win32_64.KEY_WOW64_64KEY)
    if type(ktype) == str or type(ktype) == unicode: ktype = getattr(_winreg, ktype)
    # SetValueEx attend un entier et le transforme lui-mme en hexadcimale
    if ktype == _winreg.REG_DWORD: kval = int(kval)
    _winreg.SetValueEx(k, kname, 0, ktype, kval)
    k.Close()

# Obtenir des valeurs
def get_option(kpath, kname, hkey='HKEY_LOCAL_MACHINE'):
    hkey = gethkey(hkey)
    # if 1:
    try:
        #ouverture de la base de registre
        hkey = _winreg.OpenKey(hkey, kpath, 0, _winreg.KEY_READ | win32_64.KEY_WOW64_64KEY)
        #rcupration de la valeur
        res = _winreg.QueryValueEx(hkey, kname)[0]
        hkey.Close()
        return res
    except:
        return None

###############
## Nettoyage ##
###############
def clean_machine_reg():
    """Nettoyage du registre machine
    """
    hkey = _winreg.HKEY_LOCAL_MACHINE
    logging.info('Nettoyage du registre machine')
    clean_reg(hkey)

def clean_user_reg(sid):
    """Nettoyage du registre utilisateur
    """
    if get_option(r'Software\CRDP Bretagne\ESU', 'CleanRegistry') == 1:
        logging.info('Nettoyage du registre utilisateur')
        hkey = _winreg.HKEY_USERS
        clean_reg(hkey, sid)

def clean_reg(hkey, sid=None):
    logging.debug('Effacement des policies restrictive pour sid=%s'%sid)
    if sid: key = r'%s\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\RestrictRun'%sid
    else: key = r'Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\RestrictRun'
    delete_key(hkey, key)
    
    if sid: key = r'%s\Software\Policies\Microsoft'%sid
    else: key = r'Software\Policies\Microsoft'
    delete_key(hkey, key)
    
##    if sid: key = r'%s\Software\CRDP Bretagne\ESU'%sid
##    else: key = r'Software\CRDP Bretagne\ESU'
##    delete_key(hkey, key)

    if sid: key = r'%s\Software\Microsoft\Windows\CurrentVersion\Policies'%sid
    else: key = r'Software\Microsoft\Windows\CurrentVersion\Policies'
    try:
        kh = _winreg.OpenKey(hkey, key, 0, _winreg.KEY_ALL_ACCESS | win32_64.KEY_WOW64_64KEY)
        for subkey in get_subkeys(kh):
            delete_key(hkey, r'%s\%s'%(key, subkey))
    except: pass

def delete_key(hkey, key):
    try: _winreg.DeleteKeyEx(hkey, key, 0, _winreg.KEY_ALL_ACCESS | win32_64.KEY_WOW64_64KEY)
    except: pass

def get_subkeys(kh):
    """kh est un handler d'une cl (OpenKey)
    renvoie la liste des sous cls
    """
    liste = list()
    for i in range(_winreg.QueryInfoKey(kh)[0]):
        liste.append(_winreg.EnumKey(kh, i))
    return liste


####################
## Ajout en masse ##
####################
def put_regs(reg_liste, sid=None):
    """
    reg_liste = [reg_dict, ]
    reg_dict = {'hkey': 'HKEY_LOCAL_MACHINE', 'keypath': 'software\\eole', 'keytype': 'REG_SZ',
                   'keyname': 'gougoul', 'value': '8764164'}
    """
    logging.debug('Appel')
    if type(reg_liste) == dict:
        reg_liste = [reg_liste]
    for reg_dict in reg_liste:
        hkey = getattr(_winreg, reg_dict['hkey'])
        hk = _winreg.ConnectRegistry(None, hkey)
        ktype = getattr(_winreg, reg_dict['keytype'])
        kpath = reg_dict['keypath']
        kname = reg_dict['keyname']
        kval = reg_dict['value']
        if sid and 'HKEY_USERS' in reg_dict['hkey']: wait_create_hive(hk, sid)
        if kval.upper() == 'IGNORE': continue
        elif kval.upper() == 'SUPPRALL':
            delete_key(hkey, kpath)
        elif kval.upper() == 'SUPPR':
            try:
                delreg(hkey, kpath, kname)
            except Exception, e:
                logging.error("erreur de suppression de la variable %s (%s)"%(kname, e))
                logging.debug('Erreur %s'%traceback.format_exc())
        else:
            try:
                addreg(hkey, kpath, ktype, kname, kval)
            except Exception, e:
                logging.error("erreur d'enregistrement de la variable (hk=%s, kpath=%s, ktype=%s, kname=%s, kval=%s) :"%(reg_dict['hkey'], kpath, ktype, kname, kval))
                logging.error('%s'%e)
                logging.debug('Erreur %s'%traceback.format_exc())
        _winreg.CloseKey(hk) # dconnexion de HKEY_
    return True

def wait_create_hive(hk, sid):
    """Utilis lors de l'ouverture de session, attend que HKEY_USERS\SID soit cr par
    le tlchargement du profil ou l'installation du profil DefaultUser
    """
    for test in range(300): # on attend 300 diximes de secondes
        try:
            key = _winreg.OpenKey(hk, sid, 0, _winreg.KEY_ALL_ACCESS | win32_64.KEY_WOW64_64KEY)
            _winreg.CloseKey(key)
            break
        except:
            if (test%10 == 0) : logging.debug("Attente creation entree #%s (hkey=%s, sid=%s)"%(str(test+1), hk, sid))
            sleep(0.1)
