# _*_ coding: iso-8859-1 _*_
#!/usr/bin/env python

import time
import socket
import struct
import logging
import win32api as wa

#0  tm_year  	(for example, 1993)
#1 	tm_mon 	range [1,12]
#2 	tm_mday 	range [1,31]
#3 	tm_hour 	range [0,23]
#4 	tm_min 	range [0,59]
#5 	tm_sec 	range [0,61]; see (1) in strftime() description
#6 	tm_wday 	range [0,6], Monday is 0
#7 	tm_yday 	range [1,366]
#8 	tm_isdst 	0, 1 or -1; see below
#
#typedef struct _SYSTEMTIME {
#  WORD wYear;
#  WORD wMonth;
#  WORD wDayOfWeek; //Sunday is 0
#  WORD wDay;
#  WORD wHour;
#  WORD wMinute;
#  WORD wSecond;
#  WORD wMilliseconds;
#} SYSTEMTIME, 
# *PSYSTEMTIME;

TIME1970 = 2208988800L      # Thanks to F.Lundh

def timetowin(scds):
    t = time.gmtime(scds)
    y, m, dw, d, h, mn, s, ms = t[0], t[1], [1, 2, 3, 5, 6, 0][t[6]], t[2], t[3], t[4], t[5], 0
    return y, m, dw, d, h, mn, s, ms

def settime(server):
    try:
        client = socket.socket( socket.AF_INET, socket.SOCK_DGRAM )
        client.settimeout(1.5)
        data = '\x1b' + 47 * '\0'
        client.sendto( data, ( server, 123 ))
        data, address = client.recvfrom( 1024 )
        t = struct.unpack( '!12I', data ) #[10]
        t = t[10]
        t -= TIME1970
        logging.debug('Time=%s' % time.ctime(t))
        t = timetowin(t)
        wa.SetSystemTime(*t)
    except Exception, e:
        logging.error('%s'%e)

#settime('pool.ntp.org')

