# _*_ coding: iso-8859-1 _*_
#
# gestion du fichier %WINDIR%\system32\drivers\etc\hosts
# et %WINDIR%\system32\drivers\etc\lmhosts.sam
# pour accélérer la résolution du domaine
#
# Gestion des groupes de dmarrage de service
# Ajoute un groupe Eolegroup et y associe servscribe

import os, sys
import win32api as wa
import win32service

from eole import option, reg
from eole.os_type import type_os, sp, wtype

# ne pas gnrer de *.exe.log
if option.get_log_level() > 10:
    sys.stderr = sys.stdout
##import logging

HOSTS = os.path.join(os.environ['WINDIR'], r'system32\drivers\etc\hosts')
LMHOSTS = os.path.join(os.environ['WINDIR'], r'system32\drivers\etc\lmhosts.sam')
SCRIBE = option.get_nom_scribe().upper()
DOMAINE = option.get_nom_domaine().upper()
IP = option.get_ip_scribe()
SERVICEGRP = 'Eolegroup'

# #######
# HOSTS #
def addtohosts():
    c = file(HOSTS).readlines()
    r = []
    scribe_line = '%s    %s\n'%(IP, SCRIBE)
    # parcours du fichier "hosts", suppression (non-copie) des mauvaises lignes
    # et ajout de la ligne "1.1.1.1    scribe" si non trouve
    for i in c:
        if not i.endswith('\n'): i+='\n'
        if not i.strip().startswith('#') and i.strip():
            try:
                ip, host = i.strip().split()[:2]
                host = host.upper().split('.')[0] #au cas o scribe.domaine.lan
            except:
                continue
            # Suppression des anciennes/mauvaises lignes
            if ip == IP:
                continue
            elif host == SCRIBE:
                continue
        r.append(i) # la ligne est bonne, elle est conserve
    # reecriture de "HOSTS"
    r.append(scribe_line)
    file(HOSTS, 'w').writelines(r)

def delfromhosts():
    c = file(HOSTS).readlines()
    r = []
    rewrite = False
    # parcours du fichier "hosts", suppression (non copie)
    # de la ligne "1.1.1.1    scribe"
    for i in c:
        if i.strip().startswith('#') or not i.strip():
            r.append(i) # on conserve les commentaires et les lignes vides
            continue
        try:
            ip, host = i.strip().split()[:2]
        except:
            continue
        host = host.upper().split('.')[0] #au cas o scribe.domaine.lan
        if host == SCRIBE: # bon nom
            if ip == IP: # mauvaise IP
                rewrite = True
                continue
        r.append(i) # la ligne est bonne, elle est conserve

    if rewrite:
##        logging.info('reecriture de "%s"'%HOSTS)
        print 'reecriture de "%s"'%HOSTS
        file(HOSTS, 'w').writelines(r)

# #######
# LMHOSTS #
def addtolmhosts():
    c = file(LMHOSTS).readlines()
    r = []
    scribe_line = '%s    %s       #PRE #DOM:%s\n'%(IP, SCRIBE, DOMAINE)
    d = '"%s%s\\0x1b"'%(DOMAINE, ' '*(15 - len(DOMAINE)))
    dom_line = '%s    %s   #PRE\n'%(IP, d)
    # parcours du fichier "hosts", suppression (non copie) des mauvaises lignes
    # et ajout de la ligne "1.1.1.1    scribe" si non trouve
    for i in c:
        if not i.endswith('\n'): i+='\n'
        if not i.strip().startswith('#') and i.strip():
            try:
                ip, host = i.strip().split()[:2]
                host = host.upper()
                if host.startswith('"'): host = host[1:]
            except:
                continue
            # Suppression des mauvaises lignes, contenant l'IP du serveur, son nom ou celui du domaine
            if ip == IP or host == SCRIBE or host == DOMAINE:
                continue
        r.append(i) # la ligne est bonne, elle est conserve
    # reecriture de "LMHOSTS"
    r.append(scribe_line)
    r.append(dom_line)
    file(LMHOSTS, 'w').writelines(r)

def delfromlmhosts():
    c = file(LMHOSTS).readlines()
    r = []
    rewrite = False
    # parcours du fichier "hosts"
    # suppression (non copie) des la lignes '1.1.1.1    SCRIBE    #PRE #DOM:DOMAINE'
    # et '1.1.1.1    "DOMAINE        \0x1b"    #PRE'
    for i in c:
        if i.strip().startswith('#') or not i.strip():
            r.append(i) # on conserve les commentaires et les lignes vides
            continue
        try:
            ip, host = i.strip().split()[:2]
            host = host.upper()
            if host.startswith('"'): host = host[1:]
        except:
            continue
        if host == SCRIBE:
            rewrite = True
            continue
        if host == DOMAINE:
            rewrite = True
            continue
            #c.append('%s    %s'%(IP, DOMAINE))
        r.append(i) # la ligne est bonne, elle est conserve

    if rewrite:
##        logging.info('reecriture de "%s"'%LMHOSTS)
        print 'reecriture de "%s"'%LMHOSTS
        file(LMHOSTS, 'w').writelines(r)

def addRegServiceGroup():
    # Desactiver l'enregistrement AD
    if type_os in ['Win2k3', 'WinXP', 'Vista']:
        reg.addreg('HKEY_LOCAL_MACHINE',r'SOFTWARE\Policies\Microsoft\Cryptography\AutoEnrollment', 'REG_DWORD', 'AEPolicy', 32768)
        reg.addreg('HKEY_CURRENT_USER',r'Software\Policies\Microsoft\Cryptography\AutoEnrollment', 'REG_DWORD', 'AEPolicy', 32768)
    # Demarrage du service avant l'affichage de l'invite d'ouverture de session
    if type_os == 'WinXP':
        wa.WinExec('sc config servscribe group= NetworkProvider', 0)
    elif type_os in ['Win2k3', 'Vista']:
        wa.WinExec('sc config servscribe group= Network', 0)
    # Dependances
    svcdeps=["EventLog"] # dependance sur "Journal des evenements" pour les log demarrage/arret service
    if type_os == 'Win2K':
        svcdeps.append("ipfw") # dependance sur "wipfw"
    if type_os == 'Win2K3':
        svcdeps.append("ipfw")
        svcdeps.append("SENS") # dependance sur "Notification d'evenements systeme" pour "catcher" les ouverture/fermeture de sessions depuis le service
        svcdeps.append("SharedAccess") # sur le parefeu pour que le service ne demarre pas trop tot
    if type_os == 'WinXP':
        svcdeps.append("ipfw")
        svcdeps.append("SENS") # dependance sur "Notification d'evenements systeme" pour "catcher" les ouverture/fermeture de sessions depuis le service
        if  sp >= '2':
            svcdeps.append("SharedAccess") # sur le parefeu pour que le service ne demarre pas trop tot
    if type_os == 'Vista':
        svcdeps.append("MpsSvc") # dependance sur parefeu Vista
        svcdeps.append("SENS")
    wa.WinExec('sc config servscribe depend= %s'%'/'.join(svcdeps), 0)
    wa.WinExec('sc config SharedAccess start= auto') # parce que le client Scribe-2.1 desactive le demarrage de ce service sur XP SP0

def delRegServiceGroup():
    l = reg.get_option(r'SYSTEM\CurrentControlSet\Control\ServiceGroupOrder','List')
    if l.count(SERVICEGRP) != 0:
        l.remove(SERVICEGRP)
        reg.addreg('HKEY_LOCAL_MACHINE', r'SYSTEM\CurrentControlSet\Control\ServiceGroupOrder', 'REG_MULTI_SZ', 'List', l)

def modifWinXpe():
    scm = win32service.OpenSCManager("", None, win32service.SC_MANAGER_ALL_ACCESS)
    s = win32service.OpenService(scm, "MSMQ", win32service.SERVICE_ALL_ACCESS)

    retcode = win32service.QueryServiceStatus(s)
    if retcode != 16:
        win32service.ControlService(s, win32service.SERVICE_CONTROL_STOP)
        win32service.QueryServiceConfig(s)
        win32service.ChangeServiceConfig(s, win32service.SERVICE_NO_CHANGE, 4, win32service.SERVICE_NO_CHANGE, None, None, 0, None, None, None, None)
    win32service.CloseServiceHandle(s)

def main():
    msg = """Utilisation :
%s --install
%s --remove
"""%(sys.argv[0], sys.argv[0])
    if len(sys.argv) == 1:
        sys.exit(msg)
    if sys.argv[1] == '--install':
        if type_os in ['Win2K', 'Win2K3', 'WinXP', 'Vista']:
            addRegServiceGroup()
            if type_os == 'WinXP' and wtype == 320:
                print "Windows XP Embedded"
                modifWinXpe()
        addtolmhosts()
        addtohosts()
    elif sys.argv[1] == '--remove':
        if type_os in ['WinXP', 'Vista']:
            delRegServiceGroup()
        delfromlmhosts()
        delfromhosts()
    else:
        sys.exit("""Argument inconnu "%s"
%s"""%(sys.argv[1], msg))

if __name__ == '__main__':
    main()
