# _*_ coding: iso-8859-1 _*_
#########################################
# Gnration du service client SCRIBE   #
# pour la gestion du poste              #
# licence GPL Eole                      #
#########################################


import win32serviceutil
import win32service, win32security
import win32event
import win32evtlogutil
import win32com.client
import pythoncom
import servicemanager
import logging
import time
import sys

from eole.log import servscribe_log
from eole.os_type import type_os, sp

# lorsque compile en .exe les accents posent probleme
if hasattr(sys, 'setdefaultencoding'):
    import locale
    loc = locale.getdefaultlocale()
    if loc[1]:
        encoding = loc[1]
        sys.setdefaultencoding(encoding)

# dfinition du service
nom="servscribe"
libelle="Service Scribe"
svcdeps=["EventLog"]
if type_os in ['Win2K', 'WinXP']:
    svcdeps.append("ipfw")
if type_os == 'WinXP':
    svcdeps.append("SENS") # service de notification systme
    if  sp >= '2':
        svcdeps.append("SharedAccess") # parefeu windows XP
if type_os == 'Vista':
    svcdeps.append("MpsSvc") # parefeu Vista
    svcdeps.append("SENS") # service de notification systme


class MyService(win32serviceutil.ServiceFramework):
    """
       Dfinition du service Windows
    """
    _svc_name_ = nom
    _svc_display_name_ = libelle
    # dpend de "Journal des vnements" et "Notification d'vnement systme"
    _svc_deps_ = svcdeps

    def __init__(self, args):
        # paramtrage de l'observateur d'vnements
        update_eventlog()
        win32serviceutil.ServiceFramework.__init__(self, args)
        self.hWaitStop = win32event.CreateEvent(None, 0, 0, None)
        self.log = servscribe_log()
        self.log.info('Demarrage')

    def GetAcceptedControls(self):
        # say we accept them all.
        rc = win32serviceutil.ServiceFramework.GetAcceptedControls(self)
        if type_os in ['WinXP', 'Vista']: rc |= win32service.SERVICE_ACCEPT_SESSIONCHANGE
        return rc

    # All extra events are sent via SvcOtherEx (SvcOther remains as a
    # function taking only the first args for backwards compat)
    def SvcOtherEx(self, control, event_type, data):
        # This is only showing a few of the extra events - see the MSDN
        # docs for "HandlerEx callback" for more info.
        if control == win32service.SERVICE_CONTROL_SESSIONCHANGE:
            # data is a single elt tuple, but this could potentially grow
            # in the future if the win32 struct does
            msg = "Session event: type=%s, sessionid=%s" % (event_type, data)
            sn_info = self.GetUserInfo(data[0])
            try:
                msg += """
Utilisateur : %(UserName)s
Serveur : %(LogonServer)s
Domaine : %(LogonDomain)s
"""%sn_info
            except Exception, e:
                msg += '%s (%s)'%(sn_info, e)
        else:
            msg = "Other event: code=%d, type=%s, data=%s" \
                  % (control, event_type, data)

        servicemanager.LogMsg(
                servicemanager.EVENTLOG_INFORMATION_TYPE,
                0xF000, #  generic message
                (msg, '')
                )

    def GetUserInfo(self, sessionid):
        try:
            sessions = win32security.LsaEnumerateLogonSessions()[:-5]
            for sn in sessions:
                sn_info = win32security.LsaGetLogonSessionData(sn)
                if sn_info['Session'] == sessionid:
                    return sn_info
        except Exception, e:
            return 'GetUserInfo : %s '%e, sessionid

    def SvcRun(self):
        """R-criture de la mthode parce que SERVICE_RUNNING
        est renseign trop tt
        """
        self.ReportServiceStatus(win32service.SERVICE_START_PENDING, waitHint=30000)
        self.SvcDoRun()
        # Once SvcDoRun terminates, the service has stopped.
        # We tell the SCM the service is still stopping - the C framework
        # will automatically tell the SCM it has stopped when this returns.
        self.log.info('\n')
        self.ReportServiceStatus(win32service.SERVICE_STOP_PENDING)

    def SvcDoRun(self):
##        try:
        win32evtlogutil.AddSourceToRegistry(self._svc_name_, servicemanager.__file__)
        # Write a 'started' event to the event log...
        win32evtlogutil.ReportEvent(self._svc_name_,
                                    servicemanager.PYS_SERVICE_STARTING,
                                    0, # category
                                    servicemanager.EVENTLOG_INFORMATION_TYPE,
                                    (self._svc_name_, ''))
        # dmarrage du serveur PB
        self.gestServ = lance(parent=self)
        self.gestServ.servstart()
##        except Exception, e:
##            file(r'C:\serverr.wri','a').write('%s\n'%e)
        # and write a 'stopped' event to the event log.
        win32evtlogutil.ReportEvent(self._svc_name_,
                                    servicemanager.PYS_SERVICE_STOPPED,
                                    0, # category
                                    servicemanager.EVENTLOG_INFORMATION_TYPE,
                                    (self._svc_name_, ''))

    def IsStarted(self):
        self.ReportServiceStatus(win32service.SERVICE_RUNNING)
        win32evtlogutil.ReportEvent(self._svc_name_,
                                    servicemanager.PYS_SERVICE_STARTED,
                                    0, # category
                                    servicemanager.EVENTLOG_INFORMATION_TYPE,
                                    (self._svc_name_, ''))

    def SvcStop(self):
        self.ReportServiceStatus(win32service.SERVICE_STOP_PENDING)
        self.gestServ.servstop()
        win32event.SetEvent(self.hWaitStop)

    #c'est un appel diffrent quand on reboot/halt
    #que pour 'net stop servscribe'
    SvcShutdown = SvcStop


def update_eventlog():
    """Paramtre les journaux de observateur d'vnements :
    taille 2048Ko
    purge automatique des vnements les plus anciens
    """
    pythoncom.CoInitialize()
    objWMIService = win32com.client.Dispatch("WbemScripting.SWbemLocator")
    objSWbemServices = objWMIService.ConnectServer(".", "root\cimv2")
    for objItem in objSWbemServices.ExecQuery("Select * from Win32_NTEventlogFile"):
        objItem.OverwriteOutdated = 0
        objItem.MaxFileSize = 1024*1024*2
        objItem.Put_()

def lance(installSignalHandlers=0, parent=None):
    # Tant que ipfw n'est pas lanc, l'import plante
    # from servscribe_class import gestServ
    for i in range(3*60):
        # if 1:
        try:
            from servscribe_class import gestServ
            break
        except Exception, e:
            logging.debug(e)
            time.sleep(1)
            if i == 179:
                # fin du dlai : import dans l'except pour voir ce qui plante
                from servscribe_class import gestServ
                break
    g = gestServ(installSignalHandlers, parent)
    return g

if __name__ == '__main__':
    # Note that this code will not be run in the 'frozen' exe-file!!!
    if '-test' in sys.argv[1:]:
        log = servscribe_log()
        log.info('\n')
        g = lance(installSignalHandlers=1)
        g.servstart()
    else:
        win32serviceutil.HandleCommandLine(MyService)
