#!/usr/bin/env python
# -*- coding: UTF-8 -*-

###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# cliscribe.py
#
# Librairie contenant les méthodes d'appel distant aux clients windows
#
###########################################################################

# imports twisted perspective broker
from twisted.spread import pb
from twisted.internet import reactor
# timeout
#from twisted.protocols import policies
from twisted.python import log
#from twisted.python import util
import re
import sys
import time
import socket
import argparse
sys.path.append('/usr/share/eole/client')


from twisted.python import failure


# constantes #
port = 8788
##############


class TimeoutError(Exception):
    pass

#def timeout(deferred):
#    print 'coucou'
#    return deferred.errback(failure.Failure(TimeoutError("Callback timed out")))
#
#def setmytimeout(deferred, seconds, timeoutfunc=timeout, *args, **kw):
#    deferred.mytimeout = reactor.callLater(seconds, lambda: deferred.called or timeoutfunc(deferred, *args, **kw))
#    return deferred

class Cliscribe:#(policies.TimeoutMixin):
    def __init__(self, ip, tmout=15, disconnect=True):
        self.port = port
        self.ip = ip
        self.disconnect = disconnect
        self.factory = pb.PBClientFactory()
        reactor.connectTCP(self.ip, self.port, self.factory, timeout=15)
        self.d = self.factory.getRootObject()
        # gestion du timeout
        self.setmytimeout(tmout)

    def test_port(self):
        # appel de la mthode remote_logon avec type_os en argument
        # attente que utilisateur.exe se lance
        log.msg('test_port %s:%s'%(self.ip, self.port))
        nb = 0
        while True:
            try:
                s = socket.socket()
                s.settimeout(2)
                s.connect((self.ip, self.port))
                s.close()
                break
            except socket.timeout:
                pass
            except Exception, e:
                time.sleep(2)
            try: s.close()
            except: continue
            if nb >= 15 :
                raise Exception('Le service sur la station "%s" n\'a pas repondu au bout de 30 secondes'%self.ip)
            nb += 1
            pass
        return True

    def appel(self, ret=None):
        self.d.addCallback(lambda object: object.callRemote('bonjour'))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def logon(self, ret=None, logon_dict=None):
        # appel de la remote_fonction
        self.test_port()
        self.d.addCallback(lambda object: object.callRemote('logon', logon_dict))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def vnc(self, ret=None, action=None, value=None, conf=None, restart=True):
        # appel de la remote_fonction
        self.d.addCallback(lambda object: object.callRemote('winvnc', action, value, conf, restart))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def winreg(self, ret=None, reg_dict=None):
        self.d.addCallback(lambda object: object.callRemote('regedit', reg_dict))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def execute(self, ret=None, cmd=None, hide=False, nowait=True, waitinput=False, user=False):
        self.d.addCallback(lambda object: object.callRemote('execute', cmd, hide, nowait, waitinput, user))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def fw(self, ret=None, cmd=None):
        self.d.addCallback(lambda object: object.callRemote('fw', cmd))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def killproc(self, ret=None, progname=None):
        self.d.addCallback(lambda object: object.callRemote('killproc', progname))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def shutdown(self, ret=None, reboot=False, force=True):
        """reboot=0 => halt, reboot=1 => reboot, reboot=2 => close session
        """
        self.d.addCallback(lambda object: object.callRemote('shutdown', reboot, force))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def bloc(self, ret=None, partmod=None, sid=None, logon=False):
        """Ne bloque que les partages, le blocage réseau est appliqué via
        execute(cmd='wipfw drop etc...') voir blocage.py
        """
        self.d.addCallback(lambda object: object.callRemote('bloc', partmod, sid, logon))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    # Fonctions de callback, errback, timeout #
    def do_disconnect(self):
        """gestion de la déconnexion
        """
        if self.disconnect:
#            log.msg('Deconnexion')
            self.d.addCallback(self.ret)
            self.d.addErrback(self.err)
        return self.d

    def ret(self, val=None):
#        log.msg('ret %s'%val)
        self.factory.disconnect()
        return val

    def err(self, val):
        try: msg = 'Erreur , %s'%val.getBriefTraceback()
        except: msg = 'Erreur, %s'%val
        log.err(msg)
        self.factory.disconnect()
        return val

    def setmytimeout(self, secds):
        """Deferred.setTimeout est deprecated et "it seems to work but it actually doesn't" (exarkun)
        si self.d.called != False => return self.d.called sinon exécute la fonction self.timeout
        """
        self.d.mytimeout = reactor.callLater(secds, lambda: self.d.called or self.timeout())
        return self.d.mytimeout

    def timeout(self):
        """ "fire" le deferred self.d pour passer au callback suivant (pour avoir au moins un retour dans l'appli
        """
        log.msg('Timeout %s'%self.ip)
        self.d.errback(failure.Failure(TimeoutError("Callback timed out")))


def valid_ip(ip):
    pattern = r"\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b"
    if re.match(pattern, ip):
       return True
    else:
       return False

def rprint(resultat):
    """
       fonction qui se contente d'afficher le résultat
       retourné par la fonction distante
    """
    print resultat
    log.msg('%s'%resultat)

def main():
    parser = argparse.ArgumentParser(formatter_class=argparse.RawTextHelpFormatter)
    parser.add_argument("IP_CLIENT", help="IP_CLIENT : IP du poste client sur lequel effectuer l'action distante")
    group = parser.add_mutually_exclusive_group()
    group.add_argument('-k', '--killproc', metavar='PROCNAME', help="""arrête le processus PROCNAME

""")
    group.add_argument('-s', '--shutdown', metavar='SHUTDOWN', choices=['0', '1', '2'], help="""SHUTDOWN=0|1|2 Extinction distante
    0=éteindre (défaut)
    1=reboot
    2=fermeture de session

""")
    group.add_argument('-e', '--execute', metavar='PROCNAME', help="""Exécute PROCNAME dans l'environnement BUILTIN/SYSTEM

""")
    group.add_argument('-eu', '--executeuser', metavar='PROCNAME', help="""Exécute PROCNAME dans l'environnement de l'utilisateur connecté s'il y en a un, sinon renvoie une erreur

""")
    group.add_argument('-vc', '--vncconnect', metavar='IP_CIBLE', help="""effectue "winvnc -connect IP_CIBLE", il faut préalablement mettre 'vncviewer' en mode "listen" sur IP_CIBLE

""")
    group.add_argument('-va', '--vncactive', metavar='ACTIVATE', choices=['0', '1'], help="""ACTIVATE=0|1 arrête (0)/démarre (1) winvnc sur IP_CLIENT

""")
    group.add_argument('-vi', '--vncinputs', metavar='INPUTS', choices=['0', '1'], help="""INPUTS=0|1 (dés)active le clavier/souris pour winvnc (0=désactivé, 1=activé)

""")
    group.add_argument('-f', '--firewall', metavar='FW_ACTION', help="""FW_ACTION : INIT|ADD::rule|DEL::Nom|SETMODE::<in>;;<out>|ACTIVATE::True|False
    * INIT initialise les règles de bases (fait une simple initalisation, ne lit pas "liste_fwregles.eol")
    * ADD::rule
        rule='Nom;; ip_src=XX;;ip_dst=XX;;action=XX;;proto=XX;;port_dst=XX;;program=XX'
            - ip_src/dst = me|any|<ip>
            - action=allow|block
            - proto=tcp|udp|icmp|any
        (Ex. 'ADD::TOTO;;ip_src=me;;ip_dst=any;;action=block;;proto=udp;;port_dst=123')
        (Ex. 'ADD::TOTO;;ip_src=me;;ip_dst=any;;action=block;;proto=any;;program=notepad.exe')
    * DEL::Nom
        (Ex. 'DEL::TOTO')
    * SETMODE::<in>;;<out>
        <in>=allow|block
        <out>=allow|block
        (Ex. "SETMODE::block;;allow")
    * ACTIVATE::True|False
""")
    args = parser.parse_args()

    #print 'ARGS', args

    if not valid_ip(args.IP_CLIENT):
        print 'IP "%s" non valide'%args.IP_CLIENT
        sys.exit(1)
    if args.killproc:
        prog = args.killproc
        print 'killproc', prog
        d = Cliscribe(args.IP_CLIENT, disconnect=False).killproc(progname=prog)
    elif args.shutdown:
        mode = args.shutdown
        print 'shutdown', mode
        d = Cliscribe(args.IP_CLIENT, disconnect=False).shutdown(reboot=mode)
    elif args.executeuser:
        prog = args.executeuser
        print 'executeuser', prog
        d = Cliscribe(args.IP_CLIENT, disconnect=False).execute(cmd=prog, user=True)
    elif args.execute:
        prog = args.execute
        print 'execute', prog
        d = Cliscribe(args.IP_CLIENT, disconnect=False).execute(cmd=prog)
    elif args.vncconnect:
        dst = args.vncconnect
        print 'vncconnect', dst
        d = Cliscribe(args.IP_CLIENT, disconnect=False).vnc(action='setinputs', value=True)
        d.addCallback(lambda _: Cliscribe(args.IP_CLIENT, disconnect=False).vnc(action='connect', value=dst))
    elif args.vncactive:
        print 'vncactive', args.vncactive
        if args.vncactive == '0':
            d = Cliscribe(args.IP_CLIENT, disconnect=False).vnc(action='stop')
        elif args.vncactive == '1':
            d = Cliscribe(args.IP_CLIENT, disconnect=False).vnc(action='start')
    elif args.vncinputs:
        inputs = args.vncinputs
        print 'vncinputs', inputs
        d = Cliscribe(args.IP_CLIENT, disconnect=False).vnc(action='setinputs', value=inputs)
    elif args.firewall:
        rule = args.firewall
        print 'firewall', rule
        d = Cliscribe(args.IP_CLIENT, disconnect=False).fw(cmd=rule)
    else:
        d = Cliscribe(args.IP_CLIENT, disconnect=False).appel()
        d.addCallback(rprint)
    d.addCallbacks(lambda _: reactor.stop(), lambda _: reactor.stop())
    reactor.run()

if __name__ == '__main__':
    main()

