# -*- coding: UTF-8 -*-

###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# twistd -noy controle_vnc_serveur.py
#
# Serveur Perspective Broker pour les clients Scribe/Windows
#
###########################################################################

# modules habituels
import os, sys
sys.path.append('/usr/share/eole/client')

# Perspective Broker
from twisted.spread import pb
#from twisted.internet import threads, reactor

# serveur HTTP
from twisted.web import server, static

# le service
from twisted.application import service, internet
from twisted.python import log
log.FileLogObserver.timeFormat = "%Y/%m/%d %H:%M:%S %Z"

# gestion des clients
from cliscribe import Cliscribe
import gest_sessions

# gestion des stations
import manage_stations

# autorisations d'accès (basé sur IP ...)
import autorisations


######################
#  appels distants   #
######################
class Echoer(pb.Root):
    """Classe contenant les fonctions distantes "remote_<func>" accessibles depuis les postes clients.
    Protection de certaines en fonction du groupe dont fait parti le login qui a ouvert une session Samba
    sur la station tentant d'accéder à la remote_fonction.
    """

#    def rootObject(self, broker):
#        """récupération d'informations sur la connection (ex: IP)
#        """
#        self.p_broker = broker
#        return pb.Root.rootObject(self, broker)

    def remoteMessageReceived(self, broker, message, args, kw):
        #self.ip = self.p_broker.transport.getPeer().host
        self.p_broker = broker
        self.ip = broker.transport.getPeer().host
        return pb.Root.remoteMessageReceived(self, broker, message, args, kw)

    #######################
    # Fonctions distantes #
    #######################

    def remote_bonjour(self, ip, ret=None):
        """Appel de la fonction bonjour sur client B par client A
        """
        if not autorisations.isprof(self.ip):
            self.p_broker.transport.loseConnection()
            log.msg('Appel non autorisé (non prof) de remote_bonjour par %s'%self.ip)
            return
        log.msg('Appel de la fonction remote_bonjour par %s sur %s'%(self.ip, ip))
        d = Cliscribe(ip).appel()
        return d

    # Gestion des postes (démarrage) #
    def remote_service_start(self, nom, ost=None, mac=None):
        """gestion des postes allumés
        """
        log.msg('Appel de la fonction remote_service_start par %s : %s (%s), mac=%s'%(self.ip, nom, ost, mac))
        return manage_stations.add_sta(self.ip, nom, ost, mac)

    # Gestion des postes (arrêt) #
    def remote_service_stop(self):
        log.msg('Appel de la fonction remote_service_stop par %s'%self.ip)
        return manage_stations.del_sta(self.ip)

    # Gestion de sessions cliente #
    # Ouverture de session
    def remote_logon(self, os_type):
        """fonction appelée par les clients lors de l'ouverture de session
        (dés)active le blocage
        """
        log.msg('Appel de la fonction remote_logon par %s'%(self.ip))
        return gest_sessions.Logon().logon(self.ip, os_type)
#        return True



#######################
# programme principal #
#######################
if __name__ == '__main__':
    sys.exit("Usage : twistd -noy %s"%os.path.basename(sys.argv[0]))

# Après un arrêt de eole-client, purge des stations allumees
manage_stations.purge()
application = service.Application('EoleClientserveur')
# serveur de téléchargement de client Scribe
root = static.File('/home/clienteole')
site = server.Site(root)
log.msg('Eole Client Serveur Fichiers demarre port:8790')
internet.TCPServer(8790, site).setServiceParent(service.IServiceCollection(application))
# serveur PB pour exécution de fonctions distantes
pbfactory = pb.PBServerFactory(Echoer(), unsafeTracebacks=True)
#pbfactory = pb.PBServerFactory(Echoer(), unsafeTracebacks=False)
log.msg('Eole Client Serveur PB demarre port:8789')
internet.TCPServer(8789, pbfactory).setServiceParent(service.IServiceCollection(application))

#PBServerFactory.unsafeTracebacks
