# _*_ coding: iso-8859-1 _*_


import os, logging
import win32api as wa
from logging.handlers import RotatingFileHandler

import option

windir = os.environ['WINDIR'] 
# fichier de log du service Scribe
SERVICE_LOG = os.path.join(windir, 'cliscribe.log')
# service de mise a jour
SERVICEMAJ_LOG = os.path.join(os.environ['WINDIR'], 'cliscribe_updater.log')
# utilisateur.py
UTILISATEUR_LOG = os.path.join(wa.GetTempPath(), 'cliscribe_utilisateur-%s.log'%wa.GetUserName())
# logon.py
LOGON_LOG = os.path.join(os.environ['WINDIR'], 'cliscribe_logon.log')

# format d'affichage
FORMATTER = logging.Formatter('%(asctime)s (%(process)d) %(levelname)s "%(funcName)s" %(message)s')
LOGON_FORMATTER = logging.Formatter('%(asctime)s (%(process)d) %(levelname)s %(message)s')


def servscribe_log():
    # on log sur 2 fichiers de 200ko
    handler = RotatingFileHandler(SERVICE_LOG,'a',200000,2)
    handler.setFormatter(FORMATTER)
    log = logging.getLogger()
    log.addHandler(handler)
    log.setLevel(option.get_log_level())
    return log

def utilisateur_log():
    handler = RotatingFileHandler(UTILISATEUR_LOG,'a',200000,0)
    handler.setFormatter(FORMATTER)
    log = logging.getLogger()
    log.addHandler(handler)
    log.setLevel(option.get_log_level())
    return log
