##################################
# Application specific variables #
##################################

# List de répertoires à créer
var_lib_eole_DIR		= $(DESTDIR)/var/lib/eole
var_lib_eole_reports_DIR	= $(var_lib_eole_DIR)/reports
var_lib_eole_config_DIR		= $(var_lib_eole_DIR)/config

vim_DIR				= $(DESTDIR)/etc/vim

remove.d_DATA_DIR		= $(eole_DIR)/remove.d

# Certificates
certificates_ca_menesr_DATA_DIR	= $(DESTDIR)/usr/share/ca-certificates/menesr
certificates_scripts_DATA_DIR	= $(eole_DIR)/certs

# Create basic structure
pretemplate_DIR			= $(eole_DIR)/pretemplate
posttemplate_DIR	   	= $(eole_DIR)/posttemplate
preservice_DIR			= $(eole_DIR)/preservice
postservice_DIR			= $(eole_DIR)/postservice

bastion_eole-firewall_REC_DIR	= $(eole_DIR)/bastion

icons_REC_DIR			= $(DESTDIR)/usr/share/icons/gnome

# schedule
schedule_daily_pre_DIR		= $(eole_DIR)/schedule/daily/pre
schedule_daily_post_DIR		= $(eole_DIR)/schedule/daily/post
schedule_weekly_pre_DIR		= $(eole_DIR)/schedule/weekly/pre
schedule_weekly_post_DIR	= $(eole_DIR)/schedule/weekly/post
schedule_monthly_pre_DIR	= $(eole_DIR)/schedule/monthly/pre
schedule_monthly_post_DIR	= $(eole_DIR)/schedule/monthly/post
schedule_once_pre_DIR		= $(eole_DIR)/schedule/once/pre
schedule_once_post_DIR		= $(eole_DIR)/schedule/once/post

# Template for lxc-create
lxc-templates_PROG_DIR		= $(DESTDIR)/usr/lib/lxc/templates

bash-completion_DATA_DIR	= $(DESTDIR)/etc/bash_completion.d

# Network interface template helper
creole_funcs_DATA_DIR   := $(DESTDIR)/usr/share/creole/funcs

grub_PROG_DIR		:= $(DESTDIR)/etc/grub.d

# Ajout de règles à exécuter durant install-dirs
install-dirs::
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/network/if-up.d
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/network/if-down.d
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/dhcp/dhclient-exit-hooks.d
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/ppp/ip-up.d
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/init.d
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/init.d-container
	$(INSTALL_DIRECTORY) $(DESTDIR)/usr/sbin
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/apt

# Ajout de règles à exécuter durant install-files
install-files::
	$(INSTALL_PROGRAM) network-scripts/ferme-firewall $(DESTDIR)/etc/network/if-up.d/
	$(INSTALL_PROGRAM) network-scripts/static-routes-add $(DESTDIR)/etc/network/if-up.d/
	$(INSTALL_PROGRAM) network-scripts/static-routes-del $(DESTDIR)/etc/network/if-down.d/
	$(INSTALL_PROGRAM) network-scripts/pppoe/bastion $(DESTDIR)/etc/ppp/ip-up.d
	$(INSTALL_DATA)    network-scripts/dhclient/bastion $(DESTDIR)/etc/dhcp/dhclient-exit-hooks.d

	$(INSTALL_PROGRAM) bastion/bastion $(DESTDIR)/etc/init.d
	$(INSTALL_PROGRAM) bastion/bastion.container $(DESTDIR)/etc/init.d-container/bastion
	$(INSTALL_PROGRAM) bastion/firewall.start $(eole_DIR)
	$(INSTALL_PROGRAM) bastion/firewall.stop  $(eole_DIR)
	$(INSTALL_PROGRAM) apt-eole $(DESTDIR)/usr/sbin
	$(INSTALL_DATA)    apt-eole.conf $(DESTDIR)/etc/apt
