#!/bin/sh

#------------------------------------------------------------------------
# forteresse.sh - Put the current server in fortress mode
# Everything is rejected except SSH for authorized networks
#
# Copyright © 2016 Pôle de compétences EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html

# Either from ifup with firewall enabled or direct call
## Reinitialisation des chaines
/sbin/iptables -F
/sbin/iptables -t nat -F
## on vide les regles utilisateurs
/sbin/iptables -t nat -X
/sbin/iptables -X
## mise en place de la politique par defaut
/sbin/iptables -P INPUT DROP
/sbin/iptables -P OUTPUT ACCEPT
/sbin/iptables -P FORWARD DROP
## lo ok
/sbin/iptables -A INPUT -i lo -j ACCEPT
#Supprime les set ipset
if [ $(command -v ipset) ]
then
    ipset -n list | while read setname; do
        ipset flush "$setname";
        ipset destroy "$setname";
    done
fi

 %if %%getVar('activer_haute_dispo', 'non') != "non"
%set %%interface_name = %%getVar(u'nom_zone_eth{0}'.format(%%corosync_dial_if))
/sbin/iptables -A INPUT -i %%interface_name -m pkttype --pkt-type multicast -j ACCEPT
/sbin/iptables -A INPUT -i %%interface_name -p udp -m udp --dport %%corosync_mcastport -j ACCEPT
 %end if

µµµµµµµµµµ range(3) => 0, 1, 2
%for %%id_interface in %%range(%%int(%%nombre_interfaces))
 %set %%phy_interface = u'eth{0}'.format(%%id_interface)
 %set %%interface_name = %%getVar(u'nom_zone_{0}'.format(%%phy_interface))
 %if %%activer_firewall == u'non'
/sbin/iptables -A INPUT -i %%interface_name -p tcp --syn -s 0/0 --dport ssh -m state --state NEW -j ACCEPT
 %else
    %if %%getVar(u'ssh_{0}'.format(%%phy_interface), u'non') == u'oui'
        %set %%mask_attribute_name = u'netmask_ssh_{0}'.format(%%phy_interface)
        %for %%res_ssh in %%getVar(u'ip_ssh_{0}'.format(%%phy_interface))
µµµµµµµµµµ Get netmask attribute
            %set %%res_mask = %%getattr(%%res_ssh,%%mask_attribute_name)
/sbin/iptables -A INPUT -i %%interface_name -p tcp --syn -s %%res_ssh/%%res_mask --dport ssh -m state --state NEW -j ACCEPT
        %end for
    %end if
 %end if
/sbin/iptables -A INPUT -i %%interface_name -m state --state ESTABLISHED,RELATED -j ACCEPT
%end for

# Manage LXC if any
if [ -x /usr/share/eole/bastion/data/90-lxc_rules ]
then
    /usr/share/eole/bastion/data/90-lxc_rules
fi
exit 0
