##################################
# Application specific variables #
##################################

# List de répertoires à créer
var_lib_eole_DIR		= $(DESTDIR)/var/lib/eole
var_lib_eole_reports_DIR	= $(var_lib_eole_DIR)/reports
var_lib_eole_config_DIR		= $(var_lib_eole_DIR)/config

sbin_PROG_DIR			= $(DESTDIR)/usr/sbin

vim_DIR				= $(DESTDIR)/etc/vim

remove.d_DATA_DIR		= $(eole_DIR)/remove.d

# Certificates
certificates_ca_letsencrypt_DATA_DIR = $(DESTDIR)/usr/share/ca-certificates/letsencrypt
certificates_ca_menesr_DATA_DIR	= $(DESTDIR)/usr/share/ca-certificates/menesr
certificates_ca_medde_DATA_DIR	= $(DESTDIR)/usr/share/ca-certificates/medde
certificates_scripts_DATA_DIR	= $(eole_DIR)/certs

# Create basic structure

bastion_eole-firewall_REC_DIR	= $(eole_DIR)/bastion

# schedule
schedule_daily_pre_DIR		= $(eole_DIR)/schedule/daily/pre
schedule_daily_post_DIR		= $(eole_DIR)/schedule/daily/post
schedule_weekly_pre_DIR		= $(eole_DIR)/schedule/weekly/pre
schedule_weekly_post_DIR	= $(eole_DIR)/schedule/weekly/post
schedule_monthly_pre_DIR	= $(eole_DIR)/schedule/monthly/pre
schedule_monthly_post_DIR	= $(eole_DIR)/schedule/monthly/post
schedule_once_pre_DIR		= $(eole_DIR)/schedule/once/pre
schedule_once_post_DIR		= $(eole_DIR)/schedule/once/post

# Template for lxc-create
lxc-templates_PROG_DIR		= $(DESTDIR)/usr/share/lxc/templates

bash-completion_DATA_DIR	= $(DESTDIR)/usr/share/bash-completion/completions
dhclient-enter-hooks.d_DATA_DIR        = $(DESTDIR)/etc/dhcp/dhclient-enter-hooks.d

# Network interface template helper
creole_funcs_DATA_DIR   := $(DESTDIR)/usr/share/creole/funcs

grub_PROG_DIR		:= $(DESTDIR)/etc/grub.d
grub.d_DATA_DIR		:= $(DESTDIR)/etc/default/grub.d

profile_DATA_DIR	:= $(DESTDIR)/etc/profile.d
letsencrypt_PROG_DIR	:= $(eole_DIR)/letsencrypt
letsencrypt_hooks-post.d_PROG_DIR	:= $(eole_DIR)/letsencrypt/hooks-post.d
majauto_pre_PROG_DIR        := $(eole_DIR)/majauto_pre

# Hook on network changes
networkd-dispatcher_routable.d_PROG_DIR := $(DESTDIR)/usr/lib/networkd-dispatcher/routable.d

# Override systemd units
systemd_ntp.service.d_DATA_DIR := $(DESTDIR)/etc/systemd/system/ntp.service.d

# Patches upstream waiting for upgrade
debsums-ignore.d_DATA_DIR	:= $(DESTDIR)/etc/eole/debsums-ignore.d
#backport-patches.d_DATA_DIR	:= $(DESTDIR)/usr/share/eole/backport-patches.d

# Ajout de règles à exécuter durant install-dirs
install-dirs::
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/network/if-up.d
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/network/if-down.d
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/dhcp/dhclient-exit-hooks.d
	$(INSTALL_DIRECTORY) $(DESTDIR)/usr/sbin-container
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/apt/apt.conf.d
	$(INSTALL_DIRECTORY) $(DESTDIR)/usr/share/eole-container
	$(INSTALL_DIRECTORY) $(DESTDIR)/etc/apparmor.d/lxc

# Ajout de règles à exécuter durant install-files
install-files::
	$(INSTALL_DATA)    network-scripts/dhclient/bastion $(DESTDIR)/etc/dhcp/dhclient-exit-hooks.d

	$(INSTALL_DATA)    apt/apt-eole.conf $(DESTDIR)/etc/apt
	$(INSTALL_DATA)    apt/90installrecommands $(DESTDIR)/etc/apt/apt.conf.d
	$(INSTALL_DATA)    lxc-default-with-cdrom $(DESTDIR)/etc/apparmor.d/lxc

	$(INSTALL_PROGRAM) bastion/bastion $(DESTDIR)/usr/sbin
	$(INSTALL_PROGRAM) bastion/bastion.container $(DESTDIR)/usr/sbin-container/bastion
	$(INSTALL_PROGRAM) bastion/firewall.start $(eole_DIR)
	$(INSTALL_PROGRAM) bastion/firewall.stop  $(eole_DIR)
	$(INSTALL_PROGRAM) bastion/firewall.stop.container  $(DESTDIR)/usr/share/eole-container/firewall.stop

#sudoers
sudoers.d_DATA_DIR   := $(DESTDIR)/etc/sudoers.d
