# 
# NE PAS EDITER CE FICHIER
#
# Utiliser <appli>.mk à inclure à la fin de Makefile

# Le variables suivantes sont a votre disposition : 
#
# SRC_APPS        : Répertoire des sources de l'application
# SRC_APPS_PLUGIN : Répertoires des plugins pour l'application
# SRC_APPS_LANG   : Répértoires des traductions
#

# Répertoires de destination

ifeq ($(PKGAPPS),oui)
#################
# Sanity checks #
#################
ifeq (, $(filter-out X.X, $(strip $(VERSION))))
$(error $$(VERSION) variable has incorrect value '$(VERSION)')
endif

ifneq ($(shell test -d $(SRC_APPS) && echo 0), 0)
$(error $$(PKGAPPS) is enable but $$(SRC_APPS)='$(SRC_APPS)' does not exist)
endif

# Envole
sharenvole_PROG_DIR     := $(DESTDIR)/usr/share/envole/$(SOURCE)

SRC_APPS                := src/$(SOURCE)-$(VERSION)
SRC_APPS_PLUGIN         := src/plugins-$(VERSION)
SRC_APPS_LANG           := src/lang-$(VERSION)

APPS_DEST   := $(DESTDIR)/var/www/html/$(SOURCE)
LANG_DEST   := $(APPS_DEST)/lang
PLUGIN_DEST := $(APPS_DEST)/plugin

install-apps-dirs::
	test ! -d $(SRC_APPS)           || $(INSTALL_DIRECTORY) $(APPS_DEST)
	test ! -d $(SRC_APPS_LANG)      || $(INSTALL_DIRECTORY) $(LANG_DEST)
	test ! -d $(SRC_APPS_PLUGIN)    || $(INSTALL_DIRECTORY) $(PLUGIN_DEST)

install-apps:: install-apps-dirs
	# Installation de l'application
	$(INSTALL_RECURSIVE) $(SRC_APPS)/* $(APPS_DEST)

	# Installation des répertoires de plugins
	$(call fc_install_file,$(INSTALL_RECURSIVE),$(SRC_APPS_PLUGIN),$(PLUGIN_DEST))

	# Installation des répertoires de traductions (lang)
	$(call fc_install_file,$(INSTALL_RECURSIVE),$(SRC_APPS_LANG),$(LANG_DEST))

## Add install-apps
install:: install-apps
endif

.PHONY: install-apps install-apps-dirs
