# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2012
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""Création de base de données et instanciation des structures
 # - MySQL
 # - Postgresql
 # - Sqlite3
"""

import os.path
from .eoledberrors import UnsupportedDatabase

DBS = {}

try:
    from .eoledbsqlite import EoleDbSqlite
    DBS.update(sqlite=EoleDbSqlite)
except ImportError:
    pass

try:
    from .eoledbpg import EoleDbPg
    DBS.update(postgres=EoleDbPg)
except ImportError:
    pass

try:
    from .eoledbmysql import EoleDbMy
    DBS.update(mysql=EoleDbMy)
except ImportError:
    pass


class EoleDbConnector(object):

    def __init__(self, params):
        self.connections = DBS
        self.params = params
        dbpass = self.params.get('dbpass')
        if dbpass is not None and os.path.isfile(dbpass):
            with open(dbpass, 'r') as pwd_file:
                self.params['dbpass'] = pwd_file.read().rstrip()
        dbrootpwd = self.params.get('dbrootpwd')
        if dbrootpwd is not None and os.path.isfile(dbrootpwd):
            with open(dbrootpwd, 'r') as pwd_file:
                self.params['dbrootpwd'] = pwd_file.read().rstrip()

    def __call__(self):
        if self.params['dbtype'] in DBS:
            return self.connections[self.params['dbtype']](self.params)
        else:
            message = 'Unsupported "{0}" database type.\n'.format(self.params['dbtype'])
            message += "\nPlease check if this database is supported by EoleDB"
            message += "\nIf it's supported please install the missing python \
                    libaries\n"
            raise UnsupportedDatabase(message)
