# -*- coding: utf-8 -*-
#########################################################################
# eole-password - password management for eole
# Copyright © 2012 Pôle de Compétence EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
#########################################################################

"""EOLE Password manage passwords for EOLE

To use Eole password you only have to play with the :class:`Manager`
provide all the necessary informations to this class will give you
the expected result "Changing passwords"

The other classes are used by :class:`Password` and "private" (even this
don't means anything for python) so don't use it !

Usage example :

handler = Manager()
handler.process()

"""

import re
#import sys
import yaml
import hashlib
import getpass
import time
import tempfile
import filecmp
import shutil
from os import remove, close, write, makedirs, listdir
from os.path import isfile, basename as bsname, dirname, join, isdir

""" Optional import for modules """

from ._eole_password import EolePassword
from ._eole_shadow import EoleShadow
from ._eole_mypwd import EoleMyPwd
from ._eole_pgpwd import EolePgPwd


""" List of Supported Engines
"""
SUPPORTED_DB = ['mysql',
                'pgsql',
                'sqlite']

class EolePwdError(Exception):
    pass

