import PAM

from ._eole_password import EolePassword 

class EoleShadow(EolePassword):
    """
    Shadow passowrd operations and manipulation

    This child of :class:`EolePassword` handle all actions for /etc/shadow
    password changing support

    This is a "private" class  used by the Interface class :class:`Password`,
    do not use !

    """
    def _is_current_password(password):
        def dummy_conv(*args):
            return ((password, 0))
        auth = PAM.pam()
        auth.start('auth')
        auth.set_item(PAM.PAM_USER, self.user)
        auth.set_item(PAM.PAM_CONV, dummy_conv)
        try:
            auth.authenticate()
            return True
        except PAM.error:
            return False

    def gen_new_password(self, mode):
        """ Generate a new crypted password.

        Set a value for :attr:`new_pass`

        This is a private class used by Password interface class do not use.

        :param mode: The password operation type (onetime or auto)
        :type mode: String (onetime or auto)
        """
        shpwd = ""
        if mode == 'auto':
            shpwd = self.gen_rand_pass()
            while self._is_current_password(shpwd):
                shpwd = self.gen_rand_pass()
            self.ncr_pass = shpwd
        elif mode == 'manual':
            print("\nChanging password :\n-------------------")
            print(("Username : %s" % self.user))
            shpwd = getpass.getpass('Password : ')
            while self._is_current_password(shpwd):
                print("Password already used! Try another one")
                shpwd = getpass.getpass('Password : ')
            self.ncr_pass = shpwd
            print("-------------------")
        else:
            raise EpwdConfig("FIXME ERROR")

    def update_password(self, operations):
        def dummy_conv(*args):
            return ((self.ncr_pass, 0))
        auth = PAM.pam()
        auth.start('password')
        auth.set_item(PAM.PAM_USER, self.user)
        auth.set_item(PAM.PAM_CONV, dummy_conv)
        auth.chauthok()

