#!/usr/bin/python3
# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# mysql_pwd.py
#
# Mise à jour des mots de passe Mysql
#
###########################################################################
"""
Outil de mise à jour des mots de passe mysql
-1-   Modifier tous les mots de passe:
root@scribe:~# mysql_pwd.py <nouveau mot de passe root>
-2-   Juste modifier le mot de passe root
root@scribe:~# mysql_pwd.py <nouveau mot de passe root> toto
-3-   Lancer l'outil de modification
root@scribe:~# mysql_pwd.py
## Réinitialisation des mots de passe Mysql ##

Nouveau mot de passe root mysql : <nouveau mot de passe root>

Voulez-vous que les autres mots de passe soient modifiés (oui/non) ?
"""

import os
import sys

from creole.eosfunc import gen_random
from pyeole.process import system_code, system_out
from pyeole.ihm import question_ouinon
from pyeole.service.error import DisabledError

from creole.client import CreoleClient

ROOT_USERNAME = 'root'

MYSQL_CMD = ['mysql', '--defaults-file=/etc/mysql/debian.cnf']

def mysql_root_passwd(new_pass, source_host):
    """
    Modifie le mot de passe mysql de l'utilisateur root
    :param new_pass: password to apply
    :type new_pass: `str`
    """
    sql_cmd = """CREATE USER IF NOT EXISTS '{}'@'{}';
             ALTER USER IF EXISTS '{}'@'{}' IDENTIFIED BY '{}';
             GRANT ALL PRIVILEGES ON *.* TO '{}'@'{}' WITH GRANT OPTION;
             flush  privileges;""".format(ROOT_USERNAME, source_host, ROOT_USERNAME, source_host, new_pass, ROOT_USERNAME, source_host)
    code, out, err = system_out(MYSQL_CMD, container='mysql', stdin=sql_cmd)
    if code == 0:
        return print("## Mot de passe modifié avec succès ##")
    else:
        print(err)
        raise Exception("[Error] Root password renew failed")


def main():
    """
        Fonction d'entrée pour la mise à jour des mots de passe mysql
    """

    # Modification du mot de passe root de mysql
    try:
        new_root_pass = sys.argv[1]
    except:
        new_root_pass = ""
        while len(new_root_pass) < 5:
            if new_root_pass != "":
                print("le mot de passe est trop court (5 caractères au moins)")
            new_root_pass = input("\nNouveau mot de passe root mysql : ")
    dico_creole = CreoleClient()
    if dico_creole.get_creole('mode_conteneur_actif') == 'oui':
        try:
            container = sys.argv[2]
            source_host = dico_creole.get_creole(f'container_ip_{container}')
        except:
            source_host = dico_creole.get_creole('adresse_ip_br0')
    else:
        source_host = 'localhost'
    mysql_root_passwd(new_root_pass, source_host)


if __name__ == "__main__":
    print("## Réinitialisation du mot de passe root Mysql ##")
    main()
