# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2012
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

import psycopg2
from eoledb import EoleDb

class EoleDbPg(EoleDb):
   """Connection a une base de donées MySQL"""

   def connect(self):
       """ Open Database connection """
       print("Open Posgresql Connection")
       self.connection = psycopg2.connect(host=self.dbhost,
               dbname=self.dbname,
               port=self.dbport,
               user=self.dbuser,
               password=self.dbpass)
       self.cursor = self.connection.cursor()

   def run(self,statement):
       """ Run SQL Statements"""
       print("Run Posgresql Statement : \n\t" + statement)

   def create_db(self):
       db = psycopg2.connect(host=self.dbhost,
               port=self.dbport,
               user=self.dbuser,
               password=self.dbpass)

       cursor = db.cursor()
       db.set_isolation_level(0)
       arr = self.get_statements(self.createscript)
       for statement in arr:
           cursor.execute(statement)

       db.commit()
       cursor.close()
       db.close()

   def instance_db(self):
       self.create_db()
       self.connect()
       print("Instance")
       for sql in self.sqlscripts:
           print("Woking on " + sql)
           statements = self.get_statements(sql)
           for elm in statements:
               self.cursor.execute(elm)
       self.close()
