# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2012
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
""" MySQL Database manipulation class
"""

import MySQLdb
import sys

from _mysql_exceptions import OperationalError
from warnings import filterwarnings
from eoledb import EoleDb
from password import EoleMyPwd
from pyeole.process import system_out


class EoleDbMy(EoleDb):
    """ MySQL Manipulation class
    """
    def __dbExists__(self):
        """ Test if a database exists
        """
        self.connect(root=True)
        req = "SHOW DATABASES LIKE '{0}';".format(self.dbname)
        res = self.cursor.execute(req)
        self.close()
        if res == 1:
            return True
        else:
            return False

    def __userExists__(self, user, host):
        """ Test if a database exists
        """
        self.connect(root=True)
        req = "SELECT EXISTS(SELECT 1 FROM mysql.user WHERE user = '{0}' AND host = '{1}')".format(user, host)
        res = self.cursor.execute(req)
        row = self.cursor.fetchone()
        self.close()
        if row is not None:
            if row[0] != 0:
                return True
            else:
                return False

    def __chRootPwd__(self):
        """ Changing root password for container mysql (#EoleSpecific)
        """
        rpwd = EoleMyPwd('root', self.dbhost, None)
        rpwd.gen_new_password('auto')
        self.dbrootpwd = rpwd.ncl_pass

        sql_in = "UPDATE mysql.user SET password=PASSWORD('{0}')".format(self.dbrootpwd)
        sql_in += "WHERE user='{0}';".format(self.dbroot)
        sql_in += "flush privileges;"
        cmd = "mysql --defaults-file=/etc/mysql/debian.cnf"

        code, out, err = system_out(cmd.split(), container=self.container, stdin=sql_in)
        if code == 0:
            self.rtpwdChanged = True
        else:
            raise Exception("[Error] Root password renew failed")


    def connect(self, root=False):
        """ Open MySQL connection
        """
        if self.dbport:
            port = self.dbport
        else:
            port = 3306

        try:
            if root:
                if hasattr(self, 'container'):
                    if self.rtpwdChanged is False:
                        self.__chRootPwd__()
                    self.connection = MySQLdb.connect(host=self.dbhost,
                                                          port=self.dbport,
                                                          user=self.dbroot,
                                                          passwd=self.dbrootpwd)
                elif hasattr(self, "dbcliconf") and self.dbhost == "127.0.0.1":
                    self.connection = \
                            MySQLdb.connect(read_default_file=self.dbcliconf)
                else:
                    self.connection = MySQLdb.connect(host=self.dbhost,
                                                      port=port,
                                                      user=self.dbroot,
                                                      passwd=self.dbrootpwd)
            else:
                self.connection = MySQLdb.connect(host=self.dbhost,
                                                  db=self.dbname,
                                                  port=port,
                                                  user=self.dbuser,
                                                  passwd=self.dbpass)

            self.cursor = self.connection.cursor()
        except OperationalError as err:
            raise err
        except:  # MySQLdb.OperationalError:
            print(str(sys.exc_info()[0]))
            raise Exception("Error while connecting to MySQL database")

    def manage_users(self):
        self.connect(root=True)
        cursor = self.cursor
        sql = []

        if self.dbhost:
            if self.__userExists__(self.dbuser, self.dbhost) is False:
                req = "grant all privileges on {0}.*".format(self.dbname)
                req += " to '{0}'@'{1}'".format(self.dbuser, self.dbhost)
                req += " identified by '{0}'".format(self.dbpass)
                sql.append(req)

        for host in self.client_hosts:
            if self.__userExists__(self.dbuser, host) is False:
                req = "grant all privileges on {0}.*".format(self.dbname)
                req += " to '{0}'@'{1}'".format(self.dbuser, host)
                req += " identified by '{0}';".format(self.dbpass)
                sql.append(req)

        sql.append("flush privileges;")

        for cmd in sql:
            cursor.execute(cmd)

    def create_db(self):
        """  Creating a Database using an sql script
        """
        self.connect(root=True)

        cursor = self.cursor
        arr = self.get_statements(self.createscript)

        for statement in arr:
            cursor.execute(statement)
        cursor.execute("COMMIT;")

        self.close()

    def instance_db(self):
        """ Create the Database
        """
        self.manage_users()
        if self.__dbExists__():
            return False
        else:
            self.create_db()
            self.connect()
            for sql in self.sqlscripts:
                statements = self.get_statements(sql)
                for elm in statements:
                    self.cursor.execute(elm)
                self.cursor.execute("COMMIT;")
            self.close()
            return True

    def update_db(self):
        """ Update the database with update scripts provided in configuration"
        """
        if self.__dbExists__():
            self.connect()
            for sql in self.updatescripts:
                statements = self.get_statements(sql)
                for elm in statements:
                    self.cursor.execute(elm)
                self.cursor.execute("COMMIT;")
            self.close()
            return True
        else:
            return False

    def change_passwords(self, local_conf=None, backup_dir=None):
        """ Change users password
        """
        if self.pwd_files:
            to_change = self.pwd_files
            if local_conf:
                to_change.append(local_conf)
            self.connect(root=True)
            # for files in to_change:
            if self.dbhost == "127.0.0.1":
                if hasattr(self, 'client_hosts'):
                    self.client_hosts.append('localhost')
                else:
                    self.client_hosts = [ "localhost" ]
            elif self.dbhost == "localhost":
                if hasattr(self, 'client_hosts'):
                    self.client_hosts.append('127.0.0.1')
                else:
                    self.client_hosts = [ "127.0.0.1" ]

            hostlist = [self.dbhost] + self.client_hosts

            try:
                pwd = EoleMyPwd(self.dbuser, self.dbhost, self.connection)
                pwd.gen_new_password('auto')
                self.dbpass = pwd.update_password(self.pwd_files, hostlist, backup_dir)
            except KeyError as err:
                msg = "Missing or unknown parameter {0} in :\n".format(err)
                for files in self.pwd_files:
                    msg += u'   {0}\n'.format(str(files))
                msg += "Please check your configuration\n"
                raise Exception(msg)

            self.close()
            return True
        else:
            return False

    def close(self):
        """ Close Database Connection """
        self.cursor.close()
        self.connection.close()

filterwarnings('ignore', category=MySQLdb.Warning)
