try:
    import MySQLdb
except:
    pass

import hashlib
from os import environ

from _eole_password import EolePassword


class EoleMyPwd(EolePassword):
    """
    MySQL password operations and manipulation this class don't use
    any password you need a my.cnf on /etc with root password.
    """
    def __init__(self, name, host, dbc):
        self.dbc = dbc
        if host == "all":
            self.host = '%'
        else:
            self.host = host
        EolePassword.__init__(self, name)


    def run_req(self, request, ret=None):
        """ Run a SQL request on opened DBCO

        This is a private class used by EoleMyPwd class do not use.
        """
        try:
            cursor = self.dbc.cursor()
            res = cursor.execute(request)
            if ret is None:
                return True
            else:
                to_rt = []
                row = cursor.fetchone()
                to_rt.append(row)
                while row is not None:
                    row = cursor.fetchone()
                    to_rt.append(row)

            return to_rt
        except:
            return None

    """def mysql_crypt_pass(self, password):
        pass1 = hashlib.sha1(password).digest()
        pass2 = hashlib.sha1(pass1).hexdigest()
        return "*" + pass2.upper()"""

    def get_user_info(self):
        req_opwd = "SELECT Password "
        req_opwd += "FROM user "
        req_opwd += "WHERE User = '%s'" % self.user
        if self.user != "root":
            req_opwd += "AND Host = '%s'" % self.host


        self.old_pass = self.run_req(req_opwd)
        if self.old_pass:
            return True
        else:
            return False

    def _user_exists(self, host=None):
        """ Check if user exists in mysql.user table
        """
        req = "SELECT EXISTS(SELECT 1 FROM mysql.user WHERE user = '{0}' ".format(self.user)
        if host is not None:
            req += "AND host = '{0}'".format(host)
        req += ");"
        res = self.run_req(req, True)
        if res is not None:
            if res[0][0] != 0:
                return True
            else:
                return False
        else:
            raise Exception("Error checking if user {0} exists".format(self.user))

    def gen_new_password(self, mode):
        """ Generate a new password
        """
        if mode == 'auto':
            self.ncl_pass = self.gen_rand_pass()
        else:
            print("\nChanging MySQL password :\n------------------------")
            print("Username : %s" % self.user)
            self.ncl_pass = getpass.getpass('Password : ')
            print("------------------------")

        #self.ncr_pass = self.mysql_crypt_pass(self.ncr_pass)

    def update_password(self, actions, hosts=None, backup_dir=None):
        """ Run all replacing password operations

        Pass a list of dict like {'file': 'filename', pattern: 'password='}

        :param actions: The actions to run
        :type actions: list of dict
        """
        if hosts:
            if type(hosts) is list:
                for hst in hosts:
                    if self.user == "root":
                        req = ("UPDATE user SET password=PASSWORD(\'%s\')" % self.ncl_pass)
                        req += (" WHERE User=\'%s\';" % self.user)
                        req += ("flush privileges;")
                    else:
                        req = u"UPDATE mysql.user SET PASSWORD=PASSWORD('{0}') ".format(self.ncl_pass)
                        req += u"WHERE user='{0}' AND host='{1}';".format(self.user, hst)
                        req += u"flush privileges;"
                    #print(req)
                    if self._user_exists(hst) is False:
                        continue
                    else:
                        if self.run_req(req, True) is None:
                            raise Exception("Error changing mysql password")

        for action in actions:
            if action.has_key('mod'):
                mod = action['mod']
            else:
                mod = None

            if action.has_key('owner'):
                owner = action['owner']
            else:
                owner = None

            if action.has_key('end_pattern'):
                endpatt = action['end_pattern']
            else:
                endpatt = None

            #print("\t\t\t Working on {0}".format(action['file']))
            self.update_conf_file(action['file'], action['pattern'], endpatt, mod, owner, backup_dir)

        return self.ncl_pass
