try:
    import psycopg2
except:
    pass

from _eole_password import EolePassword

class EolePgPwd(EolePassword):
    """
    Postgresql password operations and manipulation.
    """
    def __init__(self, name, dbc):
        self.dbc = dbc
        EolePassword.__init__(self, name)

    def open_dbc(self):
        """ Open a Data Base connection (dbc)

        This is a private class used by EolePgPwd class do not use.
        """
        conf = MAIN_CONF.get_conf("pgsql")
        host = conf['pgsql-dbhost']
        user = conf['pgsql-dbuser']
        pwd = conf['pgsql-dbpass']

        if 'pgsql-port' in conf:
            port = conf['pgsql-dbport']
        else:
            port = "5432"

        try:
            conn_str = "dbname='template1' user=" + user
            if host != "localhost":
                conn_str += " host='" + host + "'"
            conn_str += " password='" + pwd + "'"
            self.dbc = psycopg2.connect(conn_str)
        except psycopg2.OperationalError:
            msg = "Unable to open connection to posgresql server"
            print("ERROR 10: {0} : {1}".format(msg, host))
            raise EolePwdError("%s" % (msg))

    def close_dbc(self):
        """ Close the Data Base connection (dbc)

        This is a private class used by EolePgPwd class do not use.
        """
        if self.dbc:
            self.dbc.close()

    def run_req(self, request):
        """ Run a SQL request on opened DBCO

        This is a private class used by EolePgPwd class do not use.
        """
        try:
            with self.dbc.cursor() as cursor:
                res = cursor.execute(request)
                if res is None:
                    return True
                else:
                    to_rt = cursor.fetchall()
                    return to_rt
        except:
            return None

    def get_user_info(self):
        if not self.dbc:
            self.open_dbc()

        req_opwd = "SELECT passwd "
        req_opwd += "FROM pg_user "
        req_opwd += "WHERE username = '%s'" % self.user
#        if self.user != "root":
#            req_opwd += "AND Host = '%s'" % self.host

        print(req_opwd)

        self.old_pass = self.run_req(req_opwd)
        if self.old_pass:
            return True
        else:
            return False

    def gen_new_password(self, mode):
        """ Generate a new password
        """
        if mode == 'auto':
            self.ncl_pass = self.gen_rand_pass()
        else:
            print("\nChanging postgresql password :\n------------------------")
            print("Username : %s" % self.user)
            self.ncl_pass = getpass.getpass('Password : ')
            print("------------------------")
