import crypt

from _eole_password import EolePassword 

class EoleShadow(EolePassword):
    """
    Shadow passowrd operations and manipulation

    This child of :class:`EolePassword` handle all actions for /etc/shadow
    password changing support

    This is a "private" class  used by the Interface class :class:`Password`,
    do not use !

    """

    def shadowcrypt(self, password, saltlen=8, hashalgo=6, salt=None):
        """ Crypt a string to the "shadow" format

        This is a private method used by :method:`gen_new_password`,
        do not use !

        :param saltlen: Length of salt string (default 8)
        :type saltlen: Integer
        :param hashalgo: Hash algorithm  (6 for SHA512)
        :type hashalgo: Integer
        :param salt: The salt for hashing (default None means this is
        generated by :method:`self.gen_salt`)
        :type salt: String
        """

        if salt is None:
            salt = self.gen_salt(saltlen)
        return crypt.crypt(password, '$%s$%s$' % (hashalgo, salt))

    def get_user_info(self):
        """ d user informations from Shadow
        Set the value of :attr:`old_pass`

        This is a private class used by Password interface class do not use.

        :return: True of operation success False if failed
        :rtype: Boolean
        """
        try:
            pwd = shadow.getspnam(self.user)
            self.old_pass = pwd.sp_pwd
            return True
        except:
            return False

    def gen_new_password(self, mode):
        """ Generate a new crypted password.

        Set a value for :attr:`new_pass`

        This is a private class used by Password interface class do not use.

        :param mode: The password operation type (onetime or auto)
        :type mode: String (onetime or auto)
        """
        shpwd = ""
        if mode == 'auto':
            shpwd = self.gen_rand_pass()
        elif mode == 'manual':
            print("\nChanging password :\n-------------------")
            print("Username : %s" % self.user)
            shpwd = getpass.getpass('Password : ')
            print("-------------------")
        else:
            raise EpwdConfig("FIXME ERROR")

        self.ncr_pass = self.shadowcrypt(shpwd)

    def update_password(self, operations):
        print("FIXME !! Update password")
        pass

