# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2012
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
""" MySQL Database manipulation class
"""

import MySQLdb
import sys

from MySQLdb._exceptions import OperationalError
from warnings import filterwarnings
from .eoledb import EoleDb
from .password import EoleMyPwd
from pyeole.process import system_out


class EoleDbMy(EoleDb):
    """ MySQL Manipulation class
    """
    rtpwdChanged = False
    def __init__(self, obj):
        EoleDb.__init__(self, obj)
        default_conf = {}
        if self.in_cont:
            default_conf.update({'dbcont': 'mysql'})
        default_conf.update({'dbroot': 'root',
                             'dbhost': '192.0.2.50' if self.in_cont else '127.0.0.1',
                             'dbport': 3306})
        self.set_conf(default_conf)

    def __dbExists__(self):
        """ Test if a database exists
        """
        with self.connect(root=True).cursor() as cursor:
            req = "SHOW DATABASES LIKE '{0}';".format(self.dbname)
            res = cursor.execute(req)
        if res == 1:
            return True
        else:
            return False

    def __userExists__(self, user, host):
        """ Test if a database exists
        """
        with self.connect(root=True).cursor() as cursor:
            req = """SELECT EXISTS(SELECT 1 FROM mysql.user
                     WHERE user = '{0}' AND host = '{1}')""".format(user, host)
            cursor.execute(req)
            row = cursor.fetchone()
        if row is not None:
            if row[0] != 0:
                return True
            else:
                return False

    def __chRootPwd__(self):
        """ Changing root password for container mysql (#EoleSpecific)
        """
        rpwd = EoleMyPwd('root', self.dbhost, None)
        rpwd.gen_new_password('auto')
        self.dbrootpwd = rpwd.ncl_pass

        sql_in = """ALTER USER IF EXISTS '{}'@'localhost' IDENTIFIED BY '{}';
                 flush  privileges;""".format(self.dbroot, self.dbrootpwd)
        cmd = "mysql --defaults-file=/etc/mysql/debian.cnf"

        code, out, err = system_out(cmd.split(),
                container=self.dbcont, stdin=sql_in)

        if code == 0:
            self.rtpwdChanged = True
        else:
            raise Exception("[Error] Root password renew failed")

    def connect(self, root=False):
        """ Open MySQL connection
        """
        conn = None
        try:
            if root:
                if hasattr(self, 'dbcont'):
               # and self.dbhost != "127.0.0.1":
                    if self.rtpwdChanged is False:
                        self.__chRootPwd__()
                    conn = MySQLdb.connect(host=self.dbhost,
                                           port=self.dbport,
                                           user=self.dbroot,
                                           passwd=self.dbrootpwd)
                elif hasattr(self, "dbcliconf") and self.dbhost == "127.0.0.1":
                    conn = MySQLdb.connect(read_default_file=self.dbcliconf)
                else:
                    conn = MySQLdb.connect(host=self.dbhost,
                                           port=self.dbport,
                                           user=self.dbroot,
                                           passwd=self.dbrootpwd)
            else:
                conn = MySQLdb.connect(host=self.dbhost,
                                       db=self.dbname,
                                       port=self.dbport,
                                       user=self.dbuser,
                                       passwd=self.dbpass)

        except OperationalError as err:
            raise err
        except Exception as err:  # MySQLdb.OperationalError:
            print(err)
            print(str(sys.exc_info()[0]))
            raise Exception("Error while connecting to MySQL database")
        return conn

    def manage_users(self):
        with self.connect(root=True).cursor() as cursor:
            sql = []

            if self.dbhost:
                if self.__userExists__(self.dbuser, self.dbhost) is False:
                    req = "create user '{0}'@'{1}'".format(self.dbuser, self.dbhost)
                    req += " identified by '{0}';".format(self.dbpass)
                    sql.append(req)
                    req = "grant all on {0}.*".format(self.dbname)
                    req += " to '{0}'@'{1}';".format(self.dbuser, self.dbhost)
                    sql.append(req)

            for host in self.client_hosts:
                if self.__userExists__(self.dbuser, host) is False and host != self.dbhost:
                    req = "create user '{0}'@'{1}'".format(self.dbuser, host)
                    req += " identified by '{0}';".format(self.dbpass)
                    sql.append(req)
                    req = "grant all on {0}.*".format(self.dbname)
                    req += " to '{0}'@'{1}';".format(self.dbuser, host)
                    sql.append(req)

            sql.append("flush privileges;")

            for cmd in sql:
                cursor.execute(cmd)

    def create_db(self):
        """  Creating a Database using an sql script
        """
        with self.connect(root=True).cursor() as cursor:

            arr = self.get_statements(self.createscript)

            for statement in arr:
                cursor.execute(statement)

    def instance_db(self):
        """ Create the Database
        """
        self.manage_users()
        if self.__dbExists__():
            return False
        else:
            self.create_db()
            with self.connect().cursor() as cursor:
                for sql in self.sqlscripts:
                    statements = self.get_statements(sql)
                    for elm in statements:
                        cursor.execute(elm)
            return True

    def update_db(self):
        """ Update the database with update scripts provided in configuration"
        """
        if self.__dbExists__():
            with self.connect().cursor() as cursor:
                for sql in self.updatescripts:
                    statements = self.get_statements(sql)
                    for elm in statements:
                        cursor.execute(elm)
            return True
        else:
            return False

    def change_passwords(self, local_conf=None, backup_dir=None):
        """ Change users password
        """
        if self.pwd_files:
            to_change = self.pwd_files
            if local_conf:
                to_change.append(local_conf)
            conn = self.connect(root=True)
            # for files in to_change:
            if self.dbhost == "127.0.0.1":
                if hasattr(self, 'client_hosts'):
                    self.client_hosts.append('localhost')
                else:
                    self.client_hosts = ["localhost"]
            elif self.dbhost == "localhost":
                if hasattr(self, 'client_hosts'):
                    self.client_hosts.append('127.0.0.1')
                else:
                    self.client_hosts = ["127.0.0.1"]

            hostlist = [self.dbhost] + self.client_hosts
            self.client_hosts = list(set(self.client_hosts))
            try:
                pwd = EoleMyPwd(self.dbuser, self.dbhost, conn)
                pwd.gen_new_password('auto')
                self.dbpass = pwd.update_password(self.pwd_files,
                                                  hostlist, backup_dir)
            except KeyError as err:
                msg = "Missing or unknown parameter {0} in :\n".format(err)
                for files in self.pwd_files:
                    msg += '   {0}\n'.format(str(files))
                msg += "Please check your configuration\n"
                raise Exception(msg)

            conn.close()
            return True
        else:
            return False

filterwarnings('ignore', category=MySQLdb.Warning)
