# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2012
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
""" EoleDB Parent Class. This class manage the initialisation of EoleDB
    database objects.

"""
import re
DELIMITER_RE = re.compile(r'^delimiter (?P<delim>.+)$', re.I)


class EoleDb(object):
    """ Parent class for Database Manipulation
    """
    def __init__(self, obj):
        self.set_conf(obj)

    def set_conf(self, conf):
        """Complète la configuration minimale pour le backend mysql
        :param conf: configuration
        :type conf: dict
        """
        for var, value in list(conf.items()):
            self.__dict__.setdefault(var, value)

    def get_statements(self, path):
        """
        Transforme les instructions SQL d'un script en tableau
        """
        statements = []
        comment = False
        collect = False
        statement = None
        delim = ';'

        fd = open(path, "r")
        for line in fd:
            line = line.strip()
            if line.startswith("/*"):
                comment = True

            if comment and line.endswith("*/") or line.endswith('*/;'):
                comment = False
                continue

            if line.startswith("--") or len(line) == 0:
                continue

            if line.startswith("\\r"):
                line = line.replace("\\r", "USE")
                if not line.endswith(delim):
                    line += delim

            if not comment:
                if DELIMITER_RE.match(line):
                    delim = DELIMITER_RE.match(line).group('delim')
                else:
                    if statement is None:
                        statement = line + " "
                    else:
                        statement += line + " "

                    if line.endswith(delim) and statement is not None and \
                            len(statement) != 0:
                                if delim != ';':
                                    statement = statement.replace(delim, ';')
                                statements.append(statement)
                                statement = None
        statements.append("COMMIT ;")
        fd.close()
        return statements

    def run(self, statement):
        """
        FIXME Execute une commande SQL
        """
        print(("[NOT IMPLEMENTED YET] Run MySql Statement : \n\t" + statement))
