#!/bin/bash

DEBSUMS=/usr/bin/debsums
IGNOREFILE=/etc/debsums-ignore

LOGDIR=/var/log/eole-debsums
LOGFILE=${LOGDIR}/debsums.log
REPORT=${LOGDIR}/report.log

LOGROTATE=logrotate
ROTATECONF=/etc/logrotate.d/eole-debsums

DPKG=/usr/bin/dpkg

unset LANG LC_MESSAGES
export LANG=C 

test -x $DEBSUMS || exit 127
test -x $DPKG || exit 127

test -d "${LOGDIR}" || mkdir -p ${LOGDIR}

if [ -s "${LOGFILE}" ] || [ -s "${REPORT}" ]
then
    test -x ${LOGROTATE} && test -f ${ROTATECONF} && ${LOGROTATE} -f ${ROTATECONF}
    echo -n > ${LOGFILE}
    echo -n > ${REPORT}
fi

# See ionice(1)
if [ -x /usr/bin/ionice ] &&
    /usr/bin/ionice -c3 true 2>/dev/null; then
    IONICE="/usr/bin/ionice -c3"
fi

if [ -f ${IGNOREFILE} ]
then
    IGNORE_FILTER="egrep -vf ${IGNOREFILE}"
fi
$IONICE $DEBSUMS -c 2>&1 | ${IGNORE_FILTER} | tee ${LOGFILE}

TEMPFILE=$(mktemp -t eole-debsums-XXXXXX)

if [ ! -w "${TEMPFILE}" ]
then
    echo "Unable to write to ${TEMPFILE}"
    exit 1
fi

touch ${REPORT}
grep -v 'no md5sums' ${LOGFILE} > ${TEMPFILE}

while read line
do
    if echo "${line}" | grep -q '^debsums: missing file'
    then
        line=$(echo "${line}" | cut -d' ' -f4)
    fi
    dpkg -S ${line} | tee -a ${REPORT}
done < ${TEMPFILE}

rm -f ${TEMPFILE}
exit 0
