# -*- mode: python; coding: utf-8 -*-

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData, HTMLData
from zephir.monitor.agentmanager.util import status_to_img
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.util import log
from pyeole.debsums import EoleDebsumsReport
from pyeole.debsums import NoEoleDebsumsReportError
from pyeole.debsums import EoleDebsumsReportParseError

import os

REPORT_FILE = '/var/log/eole-debsums/report.log'
LXC_ROOTDIR = '/opt/lxc'

class DebsumsAlertes(Agent):
   def __init__(self, name, agents, **params):
      Agent.__init__(self, name, **params)
      # Attributs data are fetch from agents
      self.agents = agents

      try:
         # Seach for zephir id (Required for graph URL of sub agents)
         from zephir.zephir_conf.zephir_conf import id_serveur
         self.id_serveur = id_serveur
      except:
         # Not registered
         self.id_serveur = 0
      
      self.status =  status.OK()

      self.table = TableData([
            ('container', 'Conteneur', {'align':'center'}, None),
            ('status', 'État', {'align':'center'}, status_to_img),
            ('files', 'Nombre de fichiers modifiés', {'align':'center'}, None),
            ])
      title = HTMLData("<h3>Surveillance des sommes MD5 des paquets&nbsp;:</h3>")
      self.data = [ title, self.table ]

   def measure(self):
      measure=[]
      for agent in self.agents:
         measure.append( self.get_status_from_agent(agent) )
      # for item in measure:
      #    log.msg(item)
      return { self.name : measure }

   def write_data(self):
      Agent.write_data(self)
      if self.last_measure is not None:
         self.table.table_data = self.last_measure.value[self.name]

   def check_status(self):
      """Renvoi le status courant s’il est définie ou status.Unknown()"""
      if self.last_measure is not None:
         return status.OK()
      else:
         log.msg("{0} : pas de dernière mesure disponible.".format(self.name))
         return status.Unknown()

   def get_status_from_agent(self, agent):
      if agent.last_measure != None:
         num_files = len(agent.last_measure.value[agent.name])
      else:
         num_files = 0

      return { 'container' : self.agent_link(agent),
               'status'    : agent.check_status(),
               'files'     : num_files,
               }

   def agent_link(self, agent):
      return '<a href="/agents/%s/%s">%s</a>' % (self.id_serveur, agent.name, agent.container)


class Debsums(Agent):
   def __init__(self, name, container, **params):
      Agent.__init__(self, name, **params)
      self.container = container
      if container == 'root':
         self.report_file = REPORT_FILE
      else:
         # Tric: use concatenation to avoid path rezet due to absolute REPORT_FILE
         self.report_file = os.path.join(LXC_ROOTDIR, container, 'rootfs' + REPORT_FILE)

      self.status = status.Unknown()

      self.table = TableData([
            ('package', 'Paquet', {'align':'left'}, None),
            ('file', 'Fichier', {'align':'left'}, None),
            ])
      title = HTMLData("<h3>Surveillance des MD5 des paquets&nbsp;:</h3>")

      self.data = [ title, self.table ]

   def measure(self):
      measure=[]
      try:
         report = EoleDebsumsReport(filename=self.report_file)
         for pkg in report:
            for filename in report[pkg]:
               measure.append({'package': pkg, 'file': filename})
      except NoEoleDebsumsReportError, e:
         self.status = status.Unknown()
      except EoleDebsumsReportParseError, e:
         log.msg("{0}: {1}".format(self.name, e))
         self.status = status.Warn()

      if measure:
         self.status = status.Warn()
      else:
         self.status = status.OK()

      return {self.name : measure}

   def write_data(self):
      Agent.write_data(self)
      if self.last_measure is not None:
         self.table.table_data = self.last_measure.value[self.name]

   def check_status(self):
      """Renvoi le status courant s’il est définie ou status.Unknown()"""
      if self.last_measure is not None:
         return self.status
      else:
         log.msg("%s : pas de dernière mesure disponible." % self.name)
         return status.Unknown()
