# -*- coding: utf-8 -*-

from os.path import join, isfile
from os import unlink
import sys
from pathlib import Path
import importlib
from pyeole.log import init_logging
from pytest import raises
from copy import copy
log = init_logging()

def setup_module(module):
    module.HERE = Path(__file__).resolve().parent
    PATH = HERE.joinpath('extra', 'dhcp', 'salt', 'custom.py')
    spec = importlib.util.spec_from_file_location(PATH.stem, PATH)
    module.custom = importlib.util.module_from_spec(spec)
    sys.modules[PATH.stem] = custom
    spec.loader.exec_module(custom)


def setup_function(function):
    test = "generic"
    custom._force_dirs = ['/usr/share/eole/creole/dicos']
    custom._force_eoleextradico = '/usr/share/eole/creole/extra'
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    custom._reload_config = False
    if isfile(join(HERE, 'tests/data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'tests/data/{}/extra/dhcp/config.eol'.format(test)))


def teardown_function(function):
    test = "generic"
    custom._force_dirs = None
    custom._force_eoleextradico = None
    custom._force_configeol = None
    custom._force_eoleextraconfig = None
    custom._reload_config = True
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_delete():
    host = {'hostname': u'host45', 'rangename': u'test2', 'macaddress': u'6E:FF:56:A2:AF:17'}
    added = copy(host)
    added['id'] = 1
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[host]) == {}
    assert custom.get_reserved() == {'reserved': [added]}
    assert custom.del_reserved(reserved=[added]) == {}
    assert custom.get_reserved() == {'reserved': []}


def test_reserved_deleteall():
    host = {'hostname': u'host45', 'rangename': u'test2', 'macaddress': u'6E:FF:56:A2:AF:17'}
    added = copy(host)
    added['id'] = 1
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[host]) == {}
    assert custom.get_reserved() == {'reserved': [added]}
    assert custom.del_reserved(allreservations=True) == {}
    assert custom.get_reserved() == {'reserved': []}
