# -*- coding: utf-8 -*-

from os.path import dirname, abspath, join, normpath, isfile, isdir, split, splitext
from os import unlink
import sys
import imp

from py.test import raises

from pyeole.log import init_logging
from creole.loader import creole_loader

log = init_logging()

def setup_module(module):
    HERE = dirname(abspath(__file__))
    module.ROOT_PATH = normpath(join(HERE, '..'))

    # Import action from ewt-actions
    PATH = normpath(join(HERE, '..', '..', 'ewt-actions', 'ewt'))
    # the ewt-action's project has to be cloned beside eole-dhcp
    if not isdir(PATH):
        raise Exception("Please clone the ewt-action's project beside eole-dhcp for the test framework to be efficient")

    if PATH not in sys.path:
        sys.path.insert(1, PATH)

    PATH = normpath(join(HERE, '..', 'extra', 'dhcpactivation', 'salt'))
    fch = open(normpath(join(PATH, 'custom.py')), 'r')
    module.custom = imp.load_module('custom', fch, normpath(join(PATH, 'custom.py')), ('.py', 'U', 1))

    PATH = normpath(join(HERE, '..', 'extra', 'dhcp', 'salt'))
    fch = open(normpath(join(PATH, 'custom.py')), 'r')
    module.dhcp_custom = imp.load_module('dhcp_custom', fch, normpath(join(PATH, 'custom.py')), ('.py', 'U', 1))

    module.TEST_DATA_PATH = join(HERE, 'data')

def setup_function(function):
    test = join(TEST_DATA_PATH, 'generic', 'extra', 'dhcp', 'config.eol')
    if isfile(test):
        unlink(test)

    dhcp_custom._force_dirs = [join(TEST_DATA_PATH, 'base')]
    dhcp_custom._force_eoleextradico = join(ROOT_PATH, 'extra')
    dhcp_custom._force_configeol = join(TEST_DATA_PATH, 'generic', 'config.eol')
    dhcp_custom._force_eoleextraconfig = join(TEST_DATA_PATH, 'generic', 'extra')
    dhcp_custom._reload_config = False
    custom._upsert_reserved = dhcp_custom.upsert_reserved
    custom._get_subnets = dhcp_custom.get_subnets


def teardown_function(function):
    dhcp_custom._force_dirs = None
    dhcp_custom._force_eoleextradico = None
    dhcp_custom._force_configeol = None
    dhcp_custom._force_eoleextraconfig = None
    dhcp_custom._reload_config = True
    del custom._upsert_reserved
    del custom._get_subnets
    test = join(TEST_DATA_PATH, 'generic', 'extra', 'dhcp', 'config.eol')
    if isfile(test):
        unlink(test)
    dhcp_custom._EAD_DHCP = join(TEST_DATA_PATH, 'conversion', 'ead2_reservation_dhcp_empty.conf')


def test_conv_base():
    """Réservation d'IP dans la """
    custom._EAD_DHCP = join(TEST_DATA_PATH, 'conversion', 'ead2_reservation_dhcp_base.conf')
    assert dhcp_custom.get_reserved() == {'reserved': []}
    custom._convert_ead2_ead3(dict(message=dict(type='info')))
    assert dhcp_custom.get_reserved() == {'reserved': [{'macaddress': u'00:00:00:00:00:02', 'hostname': u'coucou', 'id': 1, 'ip': u'192.168.0.51'}, {'macaddress': u'00:00:00:00:00:01', 'hostname': u'toto', 'id': 2, 'ip': u'192.168.0.50'}]}

def test_conv_outside_subnet():
    """Réservation d'IP dans la """
    custom._EAD_DHCP = join(TEST_DATA_PATH, 'conversion', 'ead2_reservation_dhcp_outside_subnet.conf')
    assert dhcp_custom.get_reserved() == {'reserved': []}
    custom._convert_ead2_ead3(dict(message=dict(type='info')))
    assert dhcp_custom.get_reserved() == {'reserved': [{'macaddress': u'00:00:00:00:00:01', 'hostname': u'toto', 'id': 1, 'ip': u'192.168.0.50'}]}

def test_conv_inside_named_range():
    """Réservation d'IP dans la """
    custom._EAD_DHCP = join(TEST_DATA_PATH, 'conversion', 'ead2_reservation_dhcp_inside_named_range.conf')
    assert dhcp_custom.get_reserved() == {'reserved': []}
    custom._convert_ead2_ead3(dict(message=dict(type='info')))
    assert dhcp_custom.get_reserved() == {'reserved': [{'macaddress': u'00:00:00:00:00:02', 'hostname': u'coucou', 'id': 1, 'rangename': u'test2'}, {'macaddress': u'00:00:00:00:00:01', 'hostname': u'toto', 'id': 2, 'ip': u'192.168.0.50'}]}

def test_conv_inside_dynamic_range():
    """Réservation d'IP dans la """
    custom._EAD_DHCP = join(TEST_DATA_PATH, 'conversion', 'ead2_reservation_dhcp_inside_dynamic_range.conf')
    assert dhcp_custom.get_reserved() == {'reserved': []}
    custom._convert_ead2_ead3(dict(message=dict(type='info')))
    assert dhcp_custom.get_reserved() == {'reserved': [{'macaddress': u'00:00:00:00:00:01', 'hostname': u'toto', 'id': 1, 'ip': u'192.168.0.50'}]}
