from os.path import dirname, abspath, join, normpath
import imp
from pyeole.log import init_logging
log = init_logging()

def setup_module(module):
    HERE = dirname(abspath(__file__))
    PATH = normpath(join(HERE, '..', 'extra', 'dhcp', 'salt'))
    fch = open(normpath(join(PATH, 'custom.py')), 'r')
    module.custom = imp.load_module('custom', fch, normpath(join(PATH, 'custom.py')), ('.py', 'U', 1))
    
    
def setup_function(function):
    custom._force_dirs = ['tests/data/base']
    custom._force_eoleextradico = 'extra'
    custom._force_configeol = 'tests/data/generic/config.eol'
    custom._force_eoleextraconfig = 'tests/data/generic/extra'
    custom._reload_config = False


def teardown_function(function):
    custom._force_dirs = None
    custom._force_eoleextradico = None
    custom._force_configeol = None
    custom._force_eoleextraconfig = None
    custom._reload_config = True


def test_subnets_empty():
    custom._force_configeol = 'tests/data/subnets_empty/config.eol'
    custom._force_eoleextraconfig = 'tests/data/subnets_empty/extra'
    assert custom.get_subnets() == {'subnets': []}


def test_subnets_static_range():
    custom._force_configeol = 'tests/data/subnets_static_range/config.eol'
    custom._force_eoleextraconfig = 'tests/data/subnets_static_range/extra'
    expected = {'subnets': [{'dynamicRanges': [{'high': u'192.168.0.120', 'reservable': False, 'low': u'192.168.0.110', 'name': 'test'}], 'netmask': u'255.255.255.0', 'network': u'192.168.0.0'}]}
    assert custom.get_subnets() == expected


def test_subnets_dynamic_range():
    custom._force_configeol = 'tests/data/generic2/config.eol'
    custom._force_eoleextraconfig = 'tests/data/generic2/extra'
    expected = {'subnets': [{'dynamicRanges': [{'high': u'192.168.0.120', 'reservable': True, 'low': u'192.168.0.110', 'name': 'test'}], 'netmask': u'255.255.255.0', 'network': u'192.168.0.0'}]}
    assert custom.get_subnets() == expected


def test_subnets_two_subnets():
    custom._force_configeol = 'tests/data/subnets_two_subnets/config.eol'
    custom._force_eoleextraconfig = 'tests/data/subnets_two_subnets/extra'
    expected = {'subnets': [{'dynamicRanges': [{'high': u'192.168.0.120', 'reservable': False, 'low': u'192.168.0.110', 'name': u'test'}], 'netmask': u'255.255.255.0', 'network': u'192.168.0.0'}, {'dynamicRanges': [{'high': u'192.168.1.30', 'reservable': True, 'low': u'192.168.1.20', 'name': u'test2'}], 'netmask': u'255.255.255.0', 'network': u'192.168.1.0'}]}
    assert custom.get_subnets() == expected


def test_subnets_two_subnets_same_network():
    custom._force_configeol = 'tests/data/subnets_two_subnets_same_network/config.eol'
    custom._force_eoleextraconfig = 'tests/data/subnets_two_subnets_same_network/extra'
    expected = {'subnets': [{'dynamicRanges': [{'high': u'192.168.0.120', 'reservable': False, 'low': u'192.168.0.110', 'name': u'test'}, {'high': u'192.168.0.130', 'reservable': True, 'low': u'192.168.0.125', 'name': u'test2'}], 'netmask': u'255.255.255.0', 'network': u'192.168.0.0'}]}
    assert custom.get_subnets() == expected
