# -*- coding: utf-8 -*-

from os.path import dirname, abspath, join, normpath, isfile
from os import unlink
import imp, sys
from pyeole.log import init_logging
from py.test import raises
log = init_logging()

def setup_module(module):
    module.HERE = dirname(abspath(__file__))
    PATH = normpath(join(HERE, '..', 'extra', 'dhcp', 'salt'))
    fch = open(normpath(join(PATH, 'custom.py')), 'r')
    module.custom_desactivation = imp.load_module('custom', fch, normpath(join(PATH, 'custom.py')), ('.py', 'U', 1))
    #HERE = dirname(abspath(__file__))
    #PATH = normpath(join(HERE, '..', 'extra', 'dhcp', 'salt'))
    #if PATH not in sys.path:
    #    sys.path.insert(1, PATH)
    #module.custom_desactivation = __import__('custom')
    #sys.path.remove(PATH)

    module.custom_desactivation._force_dirs = ['/usr/share/eole/creole/dicos']
    module.custom_desactivation._force_eoleextradico = '/usr/share/eole/creole/extra'
    module.custom_desactivation._force_configeol = join(HERE, 'data/generic/config.eol')
    module.custom_desactivation._force_eoleextraconfig = join(HERE, 'data/dhcpdesactivation/extra')
    module.custom_desactivation._reload_config = False


def teardown_module(module):
    module.custom_desactivation._force_dirs = None
    module.custom_desactivation._force_eoleextradico = None
    module.custom_desactivation._force_configeol = None
    module.custom_desactivation._force_eoleextraconfig = None
    module.custom_desactivation._reload_config = True
    test = 'dhcpdesactivation'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_desactivation():
    for func in dir(custom_desactivation):
        if not func.startswith("_") and not func == 'submit':  # submit doesn't work with the whole py.test environment
            assert getattr(custom_desactivation, func)() == {"messages": [{"msg": "Veuillez d'abord activer l'action DHCP de l'EAD3.", "level": "error"}]}

