# -*- coding: utf-8 -*-

from os.path import dirname, abspath, join, isfile, isdir
from os import unlink, makedirs, removedirs, remove, listdir
from creole import template
from pytest import fixture  # , raises
from json import load

HERE = dirname(abspath(__file__))


TEST = []

DIR_NAME = join(HERE, 'data/gendhcp')
TMP_DIR = join(DIR_NAME, 'tmp')

for testfile in listdir(DIR_NAME):
    if testfile not in ['tmp', 'generic']:
        TEST.append(testfile)

execfile("/usr/share/eole/sbin/gen_dhcp", globals(), globals())


class fake_CreoleClient:
    def get(self, name, default=None):
        if name == 'dhcpactivation.dhcp_activation.dhcp_activation_ead3':
            if self.ead3:
                return u"oui"
            else:
                return u"non"
        elif self.ead3:
            if name in self.config:
                return self.config[name]
        raise Exception('unknown variable {}'.format(name))


def _get_dirs(dirname):
    fixed_name = join(dirname, 'fixed-addresses.txt')
    net1_name = join(dirname, '192.168.1.10-192.168.1.20.txt')
    net2_name = join(dirname, '192.168.2.10-192.168.2.20.txt')
    net3_name = join(dirname, '192.168.2.30-192.168.2.40.txt')
    return fixed_name, [net1_name, net2_name, net3_name]


def _delete_dirs():
    if isdir(TMP_DIR):
        for filename in listdir(TMP_DIR):
            remove(join(TMP_DIR, filename))
        removedirs(TMP_DIR)
    fixed_name, net_names = _get_dirs(TMP_DIR)
    if isfile(fixed_name):
        unlink(fixed_name)
    for net_name in net_names:
        if isfile(net_name):
            unlink(net_name)


def _get_dico():
    dico = {}
    dico['adresse_network_dhcp'] = ["192.168.1.0", "192.168.2.0", "192.168.2.0"]
    dico['adresse_network_dhcp.adresse_netmask_dhcp'] = ["255.255.255.0", "255.255.255.0",
                                                         "255.255.255.0"]
    dico['adresse_network_dhcp.ip_basse_dhcp'] = ['192.168.1.10', '192.168.2.10', '192.168.2.30']
    dico['adresse_network_dhcp.ip_haute_dhcp'] = ['192.168.1.20', '192.168.2.20', '192.168.2.40']
    dico['container_path_dhcp'] = ''
    return dico


def _get_tmpl_dico(config_file=None, ead3=False):
    dico = {'global_dhcp_lease_default': None,
            'global_dhcp_lease_max': None,
            'global_nom_domaine_dhcp': None,
            'global_adresse_ip_dns_dhcp': None,
            'global_adresse_ip_wins_primaire_dhcp': None,
            'global_adresse_ip_ntp_dhcp': None,
            'global_domain_wpad_dhcp': None,
            'adresse_ip_eth0': '192.168.0.26',
            'adresse_network_eth0': '192.168.0.0',
            'adresse_netmask_eth0': '255.255.255.0',
            'activer_tftp': 'non'}
    master = template.CreoleMaster(["192.168.1.0", "192.168.2.0", "192.168.2.0"])
    master.add_slave('adresse_netmask_dhcp', ["255.255.255.0", "255.255.255.0", "255.255.255.0"])
    master.add_slave('nom_plage_dhcp', ["test1", "test2", "test3"])
    master.add_slave('ip_basse_dhcp', ['192.168.1.10', '192.168.2.10', '192.168.2.30'])
    master.add_slave('ip_haute_dhcp', ['192.168.1.20', '192.168.2.20', '192.168.2.40'])
    master.add_slave('interdire_hotes_inconnus', ['non', 'non', 'oui'])
    master.add_slave('dhcp_lease_default', [None, None, None])
    master.add_slave('dhcp_lease_max', [None, None, None])
    master.add_slave('adresse_ip_dns_dhcp', [None, None, None])
    master.add_slave('adresse_ip_dns_secondaire_dhcp', [None, None, None])
    master.add_slave('nom_domaine_dhcp', ['ac-test.fr', 'ac-test.fr', 'ac-test.fr'])
    master.add_slave('adresse_ip_gw_dhcp', [None, None, None])
    master.add_slave('adresse_ip_ntp_dhcp', [None, None, None])
    master.add_slave('adresse_ip_wins_primaire_dhcp', [None, None, None])
    master.add_slave('adresse_ip_wins_secondaire_dhcp', [None, None, None])
    master.add_slave('adressage_statique', ['non', 'non', 'non'])
    master.add_slave('dhcp_pool_use_failover', ['non', 'non', 'non'])
    dico['adresse_network_dhcp'] = master
    template.CreoleClient = fake_CreoleClient
    template.CreoleClient.ead3 = ead3
    if config_file is None:
        template.CreoleClient.config = {}
    else:
        with open(config_file) as json:
            template.CreoleClient.config = load(json)

    return dico


def setup_function(function):
    _delete_dirs()
    makedirs(TMP_DIR)


def teardown_function(function):
    _delete_dirs()


@fixture(scope="module", params=TEST)
def test_dir(request):
    return join(DIR_NAME, request.param)


def test_load(test_dir):
    dico = _get_dico()

    # Test EAD2 action
    dhcp_conf = join(test_dir, 'dhcp.conf')
    parser = parse_ead_config(dhcp_conf)
    pools = clean_hosts_configuration(parser, dico=dico, ead_config=dhcp_conf)
    gen_dhcp_config(pools, dico=dico, dir_name=TMP_DIR)
    fixed_name, net_names = _get_dirs(test_dir)
    tmp_fixed_name, tmp_net_names = _get_dirs(TMP_DIR)
    _, generics = _get_dirs(join(DIR_NAME, 'generic'))
    with open(fixed_name) as fixed:
        file_content = fixed.read()
    with open(tmp_fixed_name) as fixed:
        tmp_file_content = fixed.read()
    assert file_content == tmp_file_content
    for idx, net_name in enumerate(net_names):
        tmp_net_name = tmp_net_names[idx]
        if isfile(net_name):
            with open(net_name) as fixed:
                file_content = fixed.read()
        else:
            with open(generics[idx]) as fixed:
                file_content = fixed.read()
        with open(tmp_net_name) as fixed:
            tmp_file_content = fixed.read()
        assert file_content == tmp_file_content

    with open(join(test_dir, 'tmpldhcp_ead2.conf')) as fixed:
        tmp_file_content = fixed.read()
    cheetah_template = template.CheetahTemplate('/usr/share/eole/creole/distrib/dhcpd.conf', _get_tmpl_dico(), {})
    assert str(cheetah_template) == tmp_file_content
    _delete_dirs()

    # Test EAD3 action
    with open(join(test_dir, 'tmpldhcp_ead3.conf')) as fixed:
        tmp_file_content = fixed.read()
    cheetah_template = template.CheetahTemplate('/usr/share/eole/creole/distrib/dhcpd.conf', _get_tmpl_dico(join(test_dir, 'config.json'), ead3=True), {})
    assert str(cheetah_template) == tmp_file_content
