# -*- coding: utf-8 -*-

from os.path import dirname, abspath, join, normpath, isfile
from os import unlink
import imp
from pyeole.log import init_logging
from py.test import raises
log = init_logging()

def setup_module(module):
    module.HERE = dirname(abspath(__file__))
    PATH = normpath(join(HERE, '..', 'extra', 'dhcp', 'salt'))
    fch = open(normpath(join(PATH, 'custom.py')), 'r')
    module.custom = imp.load_module('custom', fch, normpath(join(PATH, 'custom.py')), ('.py', 'U', 1))


def setup_function(function):
    custom._force_dirs = ['/usr/share/eole/creole/dicos']
    custom._force_eoleextradico = '/usr/share/eole/creole/extra'
    custom._force_configeol = join(HERE, 'data/generic/config.eol')
    custom._force_eoleextraconfig = join(HERE, 'data/generic/extra')
    custom._reload_config = False


def teardown_function(function):
    custom._force_dirs = None
    custom._force_eoleextradico = None
    custom._force_configeol = None
    custom._force_eoleextraconfig = None
    custom._reload_config = True


def test_reserved_list():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_add():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host45', 'id': 1, 'rangename': u'test2'}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'rangename': 'unknown', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'level': 'error',
                       'msg': "Le nom unknown ne correspond à aucune plage",
                       'rel': {'hostname': 'host46', 'macaddress': '6E:FF:56:A2:AF:17', 'rangename': 'unknown'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))

def test_reserved_add_incomplete():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{}]) == {'messages': [{'level': 'error',
                                                                   'msg': "L’adresse MAC est obligatoire pour une réservation",
                                                                   'rel': {}}]}
    assert custom.upsert_reserved(reserved=[{'macaddress': '6E:FF:56:A2:AF:17'}]) == {'messages': [{'level': 'error',
                                             'msg': "Le nom d’hôte est obligatoire pour la réservation de 6E:FF:56:A2:AF:17",
                                             'rel': {'macaddress': '6E:FF:56:A2:AF:17'}}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
            {'messages': [{'level': 'error',
                           'msg': "Pour créer l’hôte 6E:FF:56:A2:AF:17 il faut une IP ou un nom de plage",
                           'rel': {'macaddress': '6E:FF:56:A2:AF:17',
                                   'hostname': 'test2'}}]}

    assert custom.get_reserved() == {'reserved': []}

    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_add_unknown_range():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'rangename': 'unknown', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'level': 'error',
                       'msg': "Le nom unknown ne correspond à aucune plage",
                       'rel': {'hostname': 'host46', 'macaddress': '6E:FF:56:A2:AF:17', 'rangename': 'unknown'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))

def test_reserved_add_outside_subnet():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host90', 'macaddress': '6E:FF:56:A2:AF:17', 'ip': '10.10.10.10'}], save_when_error=True) == {'messages': [
        {'level': 'error',
         'msg': "L’adresse IP 10.10.10.10 n’est pas attribuable",
         'rel': {'hostname': 'host90',
                 'ip': '10.10.10.10',
                 'macaddress': '6E:FF:56:A2:AF:17'}}]}
    assert custom.get_reserved() == {'reserved': []}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_add_static():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host45', 'id': 1, 'ip': u'192.168.0.2'}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'ip': '192.168.0.122', 'macaddress': '6E:FF:56:A2:AF:18', 'rangename': 'statique'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host45', 'id': 1, 'ip': u'192.168.0.2'}, {'macaddress': u'6E:FF:56:A2:AF:18', 'ip': '192.168.0.122', 'hostname': u'host46', 'id': 2, 'rangename': u'statique'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_add_static_twice():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'msg': "L’hôte host45 (6E:FF:56:A2:AF:17) a déjà une adresse IP réservée hors plage dans le réseau 192.168.0.0/24",
                       'level': 'error',
                       'rel': {'dyn': False, 'hostname': 'host45', 'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:17'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_add_dyn_twice_name_mac():
    test = 'generic3'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test4', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_add_dyn_twice_name():
    test = 'generic3'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'rangename': 'test3', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'msg': "L’hôte host46 (6E:FF:56:A2:AF:17) est déjà associé à la plage dynamique test2 dans le réseau 192.168.0.0/24",
                       'level': 'error',
                       'rel': {'dyn': True, 'hostname': 'host46', 'macaddress': '6E:FF:56:A2:AF:17', 'rangename': 'test3'}}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host47', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'msg': "L’hôte host47 (6E:FF:56:A2:AF:17) est déjà associé à la plage dynamique test2 dans le réseau 192.168.0.0/24",
                       'level': 'error',
                       'rel': {'dyn': True, 'hostname': 'host47', 'macaddress': '6E:FF:56:A2:AF:17', 'rangename': 'test2'}}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host48', 'rangename': 'test4', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_add_dyn_twice():
    test = 'generic3'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'rangename': 'test3', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'msg': "L’hôte host46 (6E:FF:56:A2:AF:17) est déjà associé à la plage dynamique test2 dans le réseau 192.168.0.0/24",
                       'level': 'error',
                       'rel': {'dyn': True, 'hostname': 'host46', 'macaddress': '6E:FF:56:A2:AF:17', 'rangename': 'test3'}}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host47', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'msg': "L’hôte host47 (6E:FF:56:A2:AF:17) est déjà associé à la plage dynamique test2 dans le réseau 192.168.0.0/24",
                       'level': 'error',
                       'rel': {'dyn': True, 'hostname': 'host47', 'macaddress': '6E:FF:56:A2:AF:17', 'rangename': 'test2'}}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host48', 'rangename': 'test4', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_add_dyn_and_static():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'level': 'error',
                       'msg': "L’hôte host46 (6E:FF:56:A2:AF:17) est déjà associé à la plage dynamique test dans le réseau 192.168.0.0/24",
                       'rel': {'dyn': False, 'hostname': 'host46', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_add_static_and_dyn():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'rangename': 'test', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'level': 'error',
                       'msg': "L’hôte host46 (6E:FF:56:A2:AF:17) a déjà une adresse IP réservée hors plage dans le réseau 192.168.0.0/24",
                       'rel': {'dyn': True, 'hostname': 'host46', 'macaddress': '6E:FF:56:A2:AF:17', 'rangename': 'test'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_add_static_twice_ip():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AC:18'}]) == \
        {'messages': [{'msg': "L’adresse IP 192.168.0.2 n’est pas attribuable",
                       'level': 'error',
                       'rel': {'hostname': 'host46', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AC:18'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_add_static_twice_name():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test', 'macaddress': '6E:FF:56:A2:AF:18'}]) == \
        {'messages': [{'level': 'error',
                       'msg': "Le nom d’hôte host45 est déjà attribué",
                       'rel': {'hostname': 'host45', 'macaddress': '6E:FF:56:A2:AF:18', 'rangename': 'test'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_del():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host44', 'rangename': 'test2', 'macaddress': '7E:FF:56:A2:AF:17'}], del_reservations=True) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'7E:FF:56:A2:AF:17', 'hostname': u'host44', 'id': 1, 'rangename': u'test2'}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}], del_reservations=True) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host45', 'id': 2, 'rangename': u'test2'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_update():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host45', 'id': 1, 'rangename': u'test2'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_update_static():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host45', 'id': 1, 'ip': u'192.168.0.2'}]}
    assert custom.upsert_reserved(reserved=[{'id': 1, 'hostname': 'host46', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host46', 'id': 1, 'ip': u'192.168.0.2'}]}
    assert custom.upsert_reserved(reserved=[{'id': 1, 'hostname': 'host46', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:18'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:18', 'hostname': u'host46', 'id': 1, 'ip': u'192.168.0.2'}]}
    assert custom.upsert_reserved(reserved=[{'id': 1, 'hostname': 'host46', 'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:18'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:18', 'hostname': u'host46', 'id': 1, 'ip': u'192.168.0.3'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_update_static_to_dyn():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host45', 'id': 1, 'ip': u'192.168.0.2'}]}
    assert custom.upsert_reserved(reserved=[{'id': 1, 'hostname': 'host46', 'rangename':'test', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host46', 'id': 1, 'rangename': 'test'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_update_dyn_to_static():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'rangename':'test', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host46', 'id': 1, 'rangename': 'test'}]}
    assert custom.upsert_reserved(reserved=[{'id': 1, 'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host45', 'id': 1, 'ip': u'192.168.0.2', 'rangename': 'test'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_update_static_twice():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:18'}]) == {}
    assert custom.upsert_reserved(reserved=[{'id': 2, 'hostname': 'host46', 'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'msg': "L’hôte host46 (6E:FF:56:A2:AF:17) a déjà une adresse IP réservée hors plage dans le réseau 192.168.0.0/24",
                       'level': 'error',
                       'rel': {'dyn': False, 'hostname': 'host46', 'id': 2, 'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:17'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_update_dyn_twice():
    test = 'generic3'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'rangename': 'test4', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host47', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:18'}]) == {}
    assert custom.upsert_reserved(reserved=[{'id': 3, 'hostname': 'host47', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'msg': "L’hôte host47 (6E:FF:56:A2:AF:17) est déjà associé à la plage dynamique test2 dans le réseau 192.168.0.0/24",
                       'level': 'error',
                       'rel': {'dyn': True, 'hostname': 'host47', 'id': 3, 'macaddress': '6E:FF:56:A2:AF:17', 'rangename': 'test2'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_update_dyn_and_static():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:18'}]) == {}
    assert custom.upsert_reserved(reserved=[{'id': 2, 'hostname': 'host46', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'level': 'error',
                       'msg': "L’hôte host46 (6E:FF:56:A2:AF:17) est déjà associé à la plage dynamique test dans le réseau 192.168.0.0/24",
                       'rel': {'dyn': False, 'hostname': 'host46', 'id': 2, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_update_static_and_dyn():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'rangename': 'test', 'macaddress': '6E:FF:56:A2:AF:18'}]) == {}
    assert custom.upsert_reserved(reserved=[{'id': 2, 'hostname': 'host46', 'rangename': 'test', 'macaddress': '6E:FF:56:A2:AF:17'}]) == \
        {'messages': [{'level': 'error',
                       'msg': "L’hôte host46 (6E:FF:56:A2:AF:17) a déjà une adresse IP réservée hors plage dans le réseau 192.168.0.0/24",
                       'rel': {'dyn': True, 'hostname': 'host46', 'id': 2, 'macaddress': '6E:FF:56:A2:AF:17', 'rangename': 'test'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_update_static_twice_ip():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:18'}]) == {}
    assert custom.upsert_reserved(reserved=[{'id': 2, 'hostname': 'host46', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AC:18'}]) == \
        {'messages': [{'msg': "L’adresse IP 192.168.0.2 n’est pas attribuable", 'level': 'error',
                       'rel': {'hostname': 'host46', 'id': 2, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AC:18'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_update_static_twice_name():
    test = 'generic2'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host46', 'rangename': 'test', 'macaddress': '6E:FF:56:A2:AF:18'}]) == {}
    assert custom.upsert_reserved(reserved=[{'id': 2, 'hostname': 'host45', 'rangename': 'test', 'macaddress': '6E:FF:56:A2:AF:18'}]) == \
        {'messages': [{'level': 'error',
                       'msg': "Le nom d’hôte host45 est déjà attribué",
                       'rel': {'hostname': 'host45', 'id': 2, 'macaddress': '6E:FF:56:A2:AF:18', 'rangename': 'test'}}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_prefix():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}], prefix='test') == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    assert custom.upsert_reserved(reserved=[{'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:18'}], prefix='test') == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}, {'hostname': 'test1', 'id': 2, 'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:18'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_prefix_modified():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}], prefix='test') == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    assert custom.upsert_reserved(reserved=[{'id': 1, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}], prefix='test') == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test1', 'id': 1, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_saved_when_error():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}, {'hostname': 'host46', 'rangename': 'unknown', 'macaddress': '6E:FF:56:A2:AF:18'}], save_when_error=True) == \
        {'messages': [{'level': 'error', 'msg': 'Le nom unknown ne correspond à aucune plage',
                       'rel': {'hostname': 'host46', 'macaddress': '6E:FF:56:A2:AF:18', 'rangename': 'unknown'}}]}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'6E:FF:56:A2:AF:17', 'hostname': u'host45', 'id': 1, 'rangename': u'test2'}]}
#    assert custom.get_reserved() == {'reserved': []}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_not_saved_when_error():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}, {'hostname': 'host46', 'rangename': 'unknown', 'macaddress': '6E:FF:56:A2:AF:18'}]) == \
        {'messages': [{'level': 'error', 'msg': 'Le nom unknown ne correspond à aucune plage',
                       'rel': {'hostname': 'host46', 'macaddress': '6E:FF:56:A2:AF:18', 'rangename': 'unknown'}}]}
    assert custom.get_reserved() == {'reserved': []}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_del_not_saved_when_error():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host44', 'rangename': 'test2', 'macaddress': '7E:FF:56:A2:AF:17'}]) == {}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'7E:FF:56:A2:AF:17', 'hostname': u'host44', 'id': 1, 'rangename': u'test2'}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host45', 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}, {'hostname': 'host46', 'rangename': 'unknown', 'macaddress': '6E:FF:56:A2:AF:18'}], del_reservations=True) == \
        {'messages': [{'level': 'error', 'msg': 'Le nom unknown ne correspond à aucune plage',
                       'rel': {'hostname': 'host46', 'macaddress': '6E:FF:56:A2:AF:18', 'rangename': 'unknown'}}]}
    assert custom.get_reserved() == {'reserved': [{'macaddress': u'7E:FF:56:A2:AF:17', 'hostname': u'host44', 'id': 1, 'rangename': u'test2'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_host_range():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'test0', 'macaddress': '6E:FF:56:A2:AF:17'}], hosts_range={'low': '192.168.0.2', 'high': '192.168.0.30'}) == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host1', 'macaddress': '6E:FF:56:A2:AF:18'}], hosts_range={'low': '192.168.0.2', 'high': '192.168.0.3'}) == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}, {'hostname': 'host1', 'id': 2, 'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:18'}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host2', 'macaddress': '6E:FF:56:A2:AF:19'}], hosts_range={'low': '192.168.0.2', 'high': '192.168.0.3'}) == \
        {'messages': [{'level': 'error', 'msg': 'Pas d’adresse IP disponible dans la plage "192.168.0.2-192.168.0.3" pour 6E:FF:56:A2:AF:19',
                       'rel': {'hostname': 'host2', 'macaddress': '6E:FF:56:A2:AF:19'}}]}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}, {'hostname': 'host1', 'id': 2, 'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:18'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_host_range_mod():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'test0', 'macaddress': '6E:FF:56:A2:AF:17'}], hosts_range={'low': '192.168.0.2', 'high': '192.168.0.30'}) == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    assert custom.upsert_reserved(reserved=[{'id': 1, 'hostname': 'test0', 'macaddress': '6E:FF:56:A2:AF:17'}], hosts_range={'low': '192.168.0.2', 'high': '192.168.0.30'}) == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.3', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    assert custom.upsert_reserved(reserved=[{'id': 1, 'hostname': 'test0', 'macaddress': '6E:FF:56:A2:AF:17'}], hosts_range={'low': '192.168.0.3', 'high': '192.168.0.30'}) == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.4', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    assert custom.upsert_reserved(reserved=[{'id': 1, 'hostname': 'test0', 'macaddress': '6E:FF:56:A2:AF:17'}], hosts_range={'low': '192.168.0.2', 'high': '192.168.0.30'}) == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.2', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_host_dyn_range():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'test0', 'macaddress': '6E:FF:56:A2:AF:17'}], hosts_range={'rangename': 'test2'}) == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'rangename': 'test2', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_host_range_with_dynrange():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'test0', 'macaddress': '6E:FF:56:A2:AF:17'}], hosts_range={'low': '192.168.0.109', 'high': '192.168.0.130'}) == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.109', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'host1', 'macaddress': '6E:FF:56:A2:AF:18'}], hosts_range={'low': '192.168.0.109', 'high': '192.168.0.130'}) == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.109', 'macaddress': '6E:FF:56:A2:AF:17'}, {'hostname': 'host1', 'id': 2, 'ip': '192.168.0.121', 'macaddress': '6E:FF:56:A2:AF:18'}]}
    unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))


def test_reserved_redefine_range():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'test0', 'macaddress': '6E:FF:56:A2:AF:17'}], hosts_range={'low': '192.168.0.109', 'high': '192.168.0.130'}) == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.109', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'test0.ac-test.fr', 'macaddress': '6E:FF:56:A2:AF:17'}], hosts_range={'low': '192.168.0.109', 'high': '192.168.0.130'}) == \
        {'messages': [{'level': 'error',
                       'msg': "L’h\xc3\xb4te test0.ac-test.fr (6E:FF:56:A2:AF:17) a d\xc3\xa9j\xc3\xa0 une adresse IP r\xc3\xa9serv\xc3\xa9e hors plage dans le r\xc3\xa9seau 192.168.0.0/24",
                       'rel': {'dyn': False,
                               'hostname': 'test0.ac-test.fr',
                               'ip': '192.168.0.121',
                               'macaddress': '6E:FF:56:A2:AF:17'}}]}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0', 'id': 1, 'ip': '192.168.0.109', 'macaddress': '6E:FF:56:A2:AF:17'}]}
    assert custom.upsert_reserved(reserved=[{'hostname': 'test0.ac-test.fr', 'macaddress': '6E:FF:56:A2:AF:17', 'id': 1}], hosts_range={'low': '192.168.0.109', 'high': '192.168.0.130'}) == {}
    assert custom.get_reserved() == {'reserved': [{'hostname': 'test0.ac-test.fr', 'id': 1, 'ip': '192.168.0.121', 'macaddress': '6E:FF:56:A2:AF:17'}]}



def test_reserved_hostname():
    test = 'generic'
    if isfile(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test))):
        unlink(join(HERE, 'data/{}/extra/dhcp/config.eol'.format(test)))
    custom._force_configeol = join(HERE, 'data/{}/config.eol'.format(test))
    custom._force_eoleextraconfig = join(HERE, 'data/{}/extra'.format(test))
    assert custom.get_reserved() == {'reserved': []}
    assert custom.upsert_reserved(reserved=[{'hostname': 'test0', 'macaddress': '6E:FF:56:A2:AF:17'}], hosts_range={'low': '192.168.0.109', 'high': '192.168.0.130'}) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'test0.ac-test.fr', 'macaddress': '6E:FF:56:A2:AF:18'}], hosts_range={'low': '192.168.0.109', 'high': '192.168.0.130'}) == {}
    assert custom.upsert_reserved(reserved=[{'hostname': 'test_test', 'macaddress': '6E:FF:56:A2:AF:19'}], hosts_range={'low': '192.168.0.109', 'high': '192.168.0.130'}) == \
        {'messages': [{'level': 'error',
                       'msg': "Le nom d’hôte test_test n’est pas valide",
                       'rel': {'hostname': 'test_test',
                               'macaddress': '6E:FF:56:A2:AF:19'}}]}
