<?php
/**
 * Inspired from
 * http://www.esup-portail.org/display/PROJDOCUWIKICAS/CASification+de+Dokuwiki
 * Ajouté par EOLE
 * eole@ac-dijon.fr
 * http://eole.orion.education.fr
 *
 */

require_once(DOKU_INC.'inc/auth/ldap.class.php');
require_once('CAS-1.3.1/eoleCAS.php');
require_once('configCAS/cas.inc.php');

global $conf;

class auth_cas extends auth_ldap {
    public $cnfcas = null;

    function __construct() {
        global $conf;

        parent::__construct();
         if ($conf['auth']['cas']['rootcas']==NULL) {
                $conf['auth']['cas']['rootcas']='';
        }
        $this->cnfcas = $conf['auth']['cas'];
        $this->cando['external'] = true;
        $this->cando['login'] = true;
        $this->cando['logoff'] = true;

        // curl extension is needed
        if(!function_exists('curl_init')) {
            if ($this->cnf['debug'])
                msg("CAS err: CURL extension not found.",-1,__LINE__,__FILE__);
            $this->success = false;
            return;
        }
        //eolephpCAS::setDebug("/tmp/dokuwiki/cas.log");
        eolephpCAS::client(CAS_VERSION_2_0, $this->cnfcas['server'], (int) $this->cnfcas['port'],
        $this->cnfcas['rootcas'],true);

        // automatically log the user when there is a cas session opened
        if($this->cnfcas['autologin']) {
            eolephpCAS::setCacheTimesForAuthRecheck(1);
        }
        else {
            eolephpCAS::setCacheTimesForAuthRecheck(-1);
        }

        if($this->cnfcas['cert']) {
            eolephpCAS::setCasServerCert($this->cnfcas['cert']);
        }
        elseif($this->cnfcas['cacert']) {
            eolephpCAS::setCasServerCACert($this->cnfcas['cacert']);
        }
        else {
            eolephpCAS::setNoCasServerValidation();
        }
		
		if (__CAS_LOGOUT){
			if($this->cnfcas['handlelogoutrequest']) {
				eolephpCAS::handleLogoutRequests(false);
			}
		}
    }

    public function trustExternal($user,$pass,$sticky=false) {
        global $USERINFO;
        global $conf;

        $sticky ? $sticky = true : $sticky = false; //sanity check

        $session = $_SESSION[$conf['title']]['auth'];

        if(eolephpCAS::checkAuthentication()) {
            $user = eolephpCAS::getUser();

            if(isset($session)) {
                $_SERVER['REMOTE_USER'] = $user;
                $USERINFO = $session['info'];
                $_SESSION[$conf['title']]['auth']['user'] = $user;
                $_SESSION[$conf['title']]['auth']['pass'] = $session['pass'];
                $_SESSION[$conf['title']]['auth']['info'] = $USERINFO;
                $_SESSION[$conf['title']]['auth']['buid'] = $session['buid'];
            } else {
                $USERINFO = $this->getUserData($user);
                $_SERVER['REMOTE_USER'] = $user;
                $_SESSION[$conf['title']]['auth']['user'] = $user;
                $_SESSION[$conf['title']]['auth']['pass'] = $pass;
                $_SESSION[$conf['title']]['auth']['info'] = $USERINFO;
                $_SESSION[$conf['title']]['auth']['buid'] = auth_browseruid();
            }

            return true;
        } else {
            eolephpCAS::forceAuthentication();
        }

        return false;
    }

    public function logIn() {
        global $QUERY;

        eolephpCAS::setFixedServiceURL(DOKU_URL . 'doku.php?id=' . $QUERY);
        eolephpCAS::forceAuthentication();
    }

    public function logOff() {
        global $QUERY;

        if($this->cnfcas['caslogout']) { // dokuwiki + cas logout
            @session_start();
            session_destroy();
            eolephpCAS::logoutWithRedirectService(DOKU_URL . 'doku.php?id=' . $QUERY);
        }
        else { // dokuwiki logout only
            @session_start();
            session_destroy();
        }
    }
}
//Setup VIM: ex: et ts=4 enc=utf-8
