# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action navigation_filters
#
# Edite les differentes regles de filtrage
#
###########################################################################

""" Action de gestion des filtres web sur un amon """

from twisted.python import log

from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
import ead2.backend.actions.amon.amon_tools as t
from ead2.backend.actions.amon import forms
from ead2.backend.actions.amon import whitesitelist_forms
from ead2.backend.actions.amon import menus
from ead2.backend.config.filenames import navigation_filters

used_templates = ['main', 'form', 'formselect', 'accordion']
zone_libelle = t.get_zone_libelle(2)

signalement_msg = navigation_filters['signalement_msg']

class FiltresWebPedago(Action):
    """ gestion des filtres optionnels de guardian pour la zone pedago"""
    user_description = Dict(default={},
                            doc="description de l'éxécutant",
                            keys=['ip', 'name', 'role'])
    name = 'opt_filters_pedago'
    libelle = "Sites"
    description = "Activation des listes de sites optionnelles sur '%s'" % (
                                                        zone_libelle.lower(),)
    category = zone_libelle.capitalize()
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                    keys=['server', 'action'])
    form_result = Dict(default={},
                        doc="retour formulaire de la requete en cours coté frontend",
                        keys = ['opt_filters_form'])
    def execute(self):
        """ renvoie les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)
        if 'opt_filters_form' in self.form_result:
            try:
                datas = forms.valid_opt_filters_form(self.form_result['opt_filters_form'],
                                                     'pedago')
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                     confirm=False)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_opt_filters', templates=used_templates)
        result = {'titre': self.description, 'sstitre':''}
        result['menus'] = menus.get_filters_menus(self.server_nb, 'filtres', 'pedago')
        result.update(forms.get_opt_filters_form('pedago'))
        result['validate'] = self.valid_btn()
        return self.send_all(result, template='amon_opt_filters', templates=used_templates)

    def valid_btn(self):
        """ renvoie les données pour la mise en forme du bouton valider """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['opt_filters_form'],
                                    'msg_container')
        title = 'Modifier la configuration des filtres'
        libelle = 'Valider'
        icone = '/image/ok.gif'
        return dict(href=href,
                    title=title,
                    libelle=libelle,
                    icone=icone)

class FiltragePedago(Action):
    """ réglage du mode de filtrage """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'filtrage_pedago'
    libelle = "Mode de filtrage pour la navigation sur '%s'" % (zone_libelle.lower(),)
    description = "Mode de filtrage pour la navigation sur '%s'" % (zone_libelle.lower(),)
    category = None
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                    keys=['server', 'action'])
    form_result = Dict(default={}, doc="retour formulaire de la requete en cours coté frontend",
                        keys = ['filtrage_form'])
    def execute(self):
        """ renvoie les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)
        if 'filtrage_form' in self.form_result:
            try:
                datas = forms.valid_filtrage_form(self.form_result['filtrage_form'], 'pedago')
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                     confirm=False)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_filtrage', templates=used_templates)
        result = {'titre': self.description, 'sstitre':''}
        result['menus'] = menus.get_filters_menus(self.server_nb, 'filtrage', 'pedago')
        result.update(forms.get_filtrage_form('pedago'))
        result['validate'] = self.valid_btn()
        return self.send_all(result, template='amon_filtrage', templates=used_templates)

    def valid_btn(self):
        """ renvoie les données pour la mise en forme du bouton valider """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['filtrage_form'],
                                    'msg_container')
        title = 'Modifier les règles de filtrage'
        libelle = 'Valider'
        icone = '/image/ok.gif'
        return dict(href=href,
                    title=title,
                    libelle=libelle,
                    icone=icone)


class SitesInterditsPedago(Action):
    """ ajout de domaines interdits à la liste """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'sites_interdits_pedago'
    libelle = "Gestion des domaines interdits sur '%s'" % (
                                   zone_libelle.lower(),)
    description = libelle
    category = None
    request = Dict(default={},
                    doc="arguments de la requete en cours cote frontend",
                    keys=['server', 'action'])
    form_result = Dict(default={},
                       doc="retour formulaire de la requete en cours coté frontend",
                       keys = ['sitelist_form', 'site_names', 'site_table'])

    def execute(self):
        """ renvoie les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)

        if 'sitelist_form' in self.form_result:
            try:
                datas = forms.valid_sitelist_form(self.form_result['sitelist_form'],
                                                   'pedago',
                                                   'blacklist')
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                     confirm=False)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_sitelist', templates=used_templates)

        elif 'site_table' in self.form_result and 'site_names' in self.form_result:
            try:
                datas = forms.valid_mod_list(self.form_result['site_names'],
                                                  self.form_result['site_table'],
                                                  'pedago',
                                                  'blacklist')
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                     confirm=False)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_sitelist', templates=used_templates)

        result = {'titre': self.description, 'sstitre':''}
        result['menus'] = menus.get_filters_menus(self.server_nb, 'blacklist', 'pedago')
        result.update(forms.get_blacklist_form('pedago'))
        result['validate'] = self.valid_btn()
        result.update(forms.get_listed('pedago', 'blacklist'))
        result['validate_mod'] = self.valid_mod_btn()
        return self.send_all(result, template='amon_sitelist', templates=used_templates)

    def valid_btn(self):
        """ renvoie les données pour la mise en forme du bouton valider """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['sitelist_form'],
                                    'msg_container')
        title = 'Ajouter des domaines à la liste des domaines interdits'
        libelle = 'Valider'
        icone = '/image/ok.gif'
        return dict(href=href,
                    title=title,
                    libelle=libelle,
                    icone=icone)

    def valid_mod_btn(self):
        """ renvoie les données pour la mise en forme du bouton valider
            (de la section de modification de blacklist locale)
        """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['site_names',
                                        'site_table'
                                        ],
                                    'msg_container')
        title = 'Modifier la liste de domaines interdits'
        libelle = 'Valider'
        icone = '/image/ok.gif'
        return dict(href=href,
                    title=title,
                    libelle=libelle,
                    icone=icone)

class SitesAutorisesPedago(Action):
    """ ajout de domaines autorisés à la liste """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'sites_autorises_pedago'
    libelle = "Gestion des domaines autorisés sur '{0}'".format(zone_libelle.lower())
    description = libelle
    category = None
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                    keys=['server', 'action'])
    form_result = Dict(default={},
                       doc="retour formulaire de la requete en cours coté frontend",
                       keys = ['sitelist_form', 'site_table', 'site_names'])

    def execute(self):
        """ renvoie les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)

        if 'sitelist_form' in self.form_result:
            try:
                datas = forms.valid_sitelist_form(self.form_result['sitelist_form'],
                                                  'pedago',
                                                  'whitelist')
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                     confirm=False)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_sitelist', templates=used_templates)

        elif 'site_table' in self.form_result and 'site_names' in self.form_result:
            try:
                datas = forms.valid_mod_list(self.form_result['site_names'],
                                                  self.form_result['site_table'],
                                                  'pedago',
                                                  'whitelist')
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                     confirm=False)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_sitelist', templates=used_templates)

        result = {'titre': self.description, 'sstitre':''}
        result['menus'] = menus.get_filters_menus(self.server_nb, 'whitelist', 'pedago')
        result.update(forms.get_whitelist_form('pedago'))
        result['validate'] = self.valid_btn()
        result.update(forms.get_listed('pedago', 'whitelist'))
        result['validate_mod'] = self.valid_mod_btn()
        return self.send_all(result, template='amon_sitelist', templates=used_templates)

    def valid_btn(self):
        """ renvoie les données pour la mise en forme du bouton valider """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['sitelist_form'],
                                    'msg_container')
        title = 'Ajouter des domaines à la liste de domaines autorisés'
        libelle = 'Valider'
        icone = '/image/ok.gif'
        return dict(href=href,
                    title=title,
                    libelle=libelle,
                    icone=icone)

    def valid_mod_btn(self):
        """ renvoie les données pour la mise en forme du bouton valider
            (de la section de modification de blacklist locale)
        """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['site_names',
                                     'site_table'],
                                    'msg_container')
        title = 'Modifier la liste de domaines autorisés'
        libelle = 'Valider'
        icone = '/image/ok.gif'
        return dict(href=href,
                    title=title,
                    libelle=libelle,
                    icone=icone)

class ExtensionsPedago(Action):
    """
        gestion des extensions interdites sur le filtre
    """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'extensions_pedago'
    libelle = 'Extensions'
    description = "Ajouter des extensions à interdire sur '%s'".format(zone_libelle.lower())
    category = None
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                    keys=['server', 'action'])
    form_result = Dict(default={}, doc="retour formulaire de la requete en cours coté frontend",
                        keys = ['extension_form', 'extlist_names', 'ext_table'])

    def execute(self):
        """ renvoie les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)

        if 'extension_form' in self.form_result:
            try:
                datas = forms.valid_extension_form(self.form_result['extension_form'], 'pedago')
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                     confirm=False)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_extension', templates=used_templates)

        elif 'extlist_names' in self.form_result and 'ext_table' in self.form_result:
            try:
                datas = forms.valid_mod_list(self.form_result['extlist_names'],
                                                  self.form_result['ext_table'],
                                                  'pedago',
                                                  'extension')
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=False)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_extension', templates=used_templates)

        result = {'titre': self.description, 'sstitre':''}
        result['menus'] = menus.get_filters_menus(self.server_nb, 'extension', 'pedago')
        result.update(forms.get_extension_form('pedago'))
        result['validate'] = self.valid_btn()
        result.update(forms.get_forbidden_extension('pedago'))
        result['validate_mod'] = self.valid_mod_btn()
        return self.send_all(result, template='amon_extension', templates=used_templates)

    def valid_btn(self):
        """ renvoie les données pour la mise en forme du bouton valider """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['extension_form'],
                                    'msg_container')
        title = 'Ajouter des sites à la liste des extensions à interdire'
        libelle = 'Valider'
        icone = '/image/ok.gif'
        return dict(href=href,
                    title=title,
                    libelle=libelle,
                    icone=icone)

    def valid_mod_btn(self):
        """ renvoie les données pour la mise en forme du bouton valider
        """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['extlist_names',
                                     'ext_table'],
                                    'msg_container')
        title = 'Modifier la liste des domaines interdits'
        libelle = 'Valider'
        icone = '/image/ok.gif'
        return dict(href=href,
                    title=title,
                    libelle=libelle,
                    icone=icone)

class MimePedago(Action):
    """
        gestion des mime interdites sur le filtre web
    """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'mime_pedago'
    libelle = 'Types Mime'
    description = "Ajouter des types mimes à interdire sur '{0}'".format(zone_libelle.lower())
    category = None
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                    keys=['server', 'action'])
    form_result = Dict(default={}, doc="retour formulaire de la requete en cours coté frontend",
                        keys = ['mime_form', 'mime_names', 'mime_table'])

    def execute(self):
        """ renvoie les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)

        if 'mime_form' in self.form_result:
            try:
                datas = forms.valid_mime_form(self.form_result['mime_form'], 'pedago')
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                     confirm=False)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_mime', templates=used_templates)

        elif 'mime_names' in self.form_result and 'mime_table' in self.form_result:
            try:
                datas = forms.valid_mod_list(self.form_result['mime_names'],
                                                  self.form_result['mime_table'],
                                                  'pedago',
                                                  'mime')
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=False)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_mime', templates=used_templates)

        result = {'titre': self.description, 'sstitre':''}
        result['menus'] = menus.get_filters_menus(self.server_nb, 'mime', 'pedago')
        result.update(forms.get_mime_form('pedago'))
        result['validate'] = self.valid_btn()
        result.update(forms.get_forbidden_mimes('pedago'))
        result['validate_mod'] = self.valid_mod_btn()
        return self.send_all(result, template='amon_mime', templates=used_templates)

    def valid_btn(self):
        """ renvoie les données pour la mise en forme du bouton valider """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['mime_form'],
                                    'msg_container')
        title = 'Ajouter des types mimes à la liste des types mimes à interdire'
        libelle = 'Valider'
        icone = '/image/ok.gif'
        return dict(href=href,
                    title=title,
                    libelle=libelle,
                    icone=icone)

    def valid_mod_btn(self):
        """ renvoie les données pour la mise en forme du bouton valider
        """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['mime_names',
                                        'mime_table'],
                                    'msg_container')
        title = 'Modifier la liste de types mimes à interdire.'
        libelle = 'Valider'
        icone = '/image/ok.gif'
        return dict(href=href,
                    title=title,
                    libelle=libelle,
                    icone=icone)

class Signalement(Action):
    """ page de signalement """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'signalement'
    libelle = 'Signalement'
    description = 'Signalement'
    category = 'Outils'
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                    keys=['server', 'action'])

    def execute(self):
        """ renvoie les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)
        result = {'titre': self.description, 'sstitre':''}
        result.update(self.get_signalement_form())
        return self.send_all(result, template='amon_signalement', templates=used_templates)

    def get_signalement_form(self):
        """ renvoie les données pour la page de signalement """
        eduscol_url = 'https://www.education.gouv.fr/la-protection-des-eleves-et-de-leurs-donnees-sur-internet-7073'
        guide = {'href':"javascript:OuvreFenetre('{}', 'Eduscol')".format(eduscol_url),
                         'libelle':"Plus d'information",
                         'icone':"/image/back.png", 'title':"Éduscol"}
        form_link = {'href':"javascript:OuvreFenetre('http://dsi.ut-capitole.fr/cgi-bin/squidguard_modify.cgi', 'Université Toulouse 1');",
                     "libelle":"Accès direct au formulaire de déclaration de site",
                     "icone":"/image/back.png",
                     'title':'Université Toulouse 1'}
        msg = t.get_lines(signalement_msg)
        return dict(signalement_text=msg,
                    signalement_form_link=form_link,
                    signalement_guide=guide)

class NavigationWhiteSiteListpedago(Action):
    """ interface de gestion des utilisateurs(ips) en liste blanche
        sur l'instance 0 de guardian
    """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'navigation_whitesitelist_pedago'
    libelle = 'Sites liste blanche'
    description = "Ajouter des sites pour le mode liste blanche sur '%s'" % (zone_libelle.lower(),)
    category = None
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                    keys=['server', 'action'])
    form_result = Dict(default={}, doc="retour formulaire de la requete en cours coté frontend",
                        keys = ['list_suppr', 'list_add'])

    def execute(self):
        """ renvoit les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)

        if 'list_add' in self.form_result:
            try:
                datas = whitesitelist_forms.valid_add_greysite(
                                            self.form_result['list_add'],
                                            zone='pedago')
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                                  confirm=True)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_whitesitelist',
                                         templates=used_templates)

        elif 'list_suppr' in self.form_result:
            try:
                datas = whitesitelist_forms.valid_mod_greysitelist(self.form_result['list_suppr'],
                                                       zone='pedago')
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name, confirm=True)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_whitesitelist',
                                         templates=used_templates)

        result = {'titre': self.description}
        result.update(whitesitelist_forms.get_add_site_form(zone='pedago'))
        result.update(whitesitelist_forms.get_greysitelist(zone='pedago'))
        result['sstitre'] =  ''
        result['menus'] = menus.get_filters_menus(self.server_nb,
                                          'whitesitelist',
                                          'pedago')
        result['validate'] = whitesitelist_forms.get_validate(self.server_nb, self.name)
        result['validate_mod'] = whitesitelist_forms.get_validate_mod(self.server_nb, self.name)
        return self.send_all(result, template='amon_whitesitelist',
                                     templates=used_templates)

