# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# Utilitaires pour la section de gestion des partages, comptes 
# et utilisateurs
#  
###########################################################################
from ead2.backend.actions.tools import make_js_link
from string import ascii_uppercase

def error_msg(action):
    """ modele de message d'erreur"""
    return "Une erreur est survenue lors %s, vérifiez l'absence d'accent et d'espace dans les champs textes"%action

def get_user_menu(server_nb, name=None):
    """ renvoit le menu utilisateur de l'api"""
    msg1 = 'Créer'
    msg2 = 'Modifier'
    msg3 = 'Supprimer'
    description1 = 'Créer un utilisateur'
    description2 = 'Modifier un utilisateur'
    description3 = 'Supprimer un utilisateur'
    icone1 = '/image/login_enable.gif'
    icone2 = '/image/login.gif'
    icone3 = '/image/login_arreter.gif'
    if name != 'gestion_user_create':
        href1 = make_js_link(server_nb, 'gestion_user_create')
    else:
        href1 = ''
    if name != 'gestion_user_modify':
        href2 = make_js_link(server_nb, 'gestion_user_modify')
    else:
        href2 = ''
    if name != 'gestion_user_suppr':
        href3 = make_js_link(server_nb, 'gestion_user_suppr')
    else:
        href3 = ''
    return [{'libelle':msg1, 'icone':icone1, 'title':description1, 'href':href1},
            {'libelle':msg2, 'icone':icone2, 'title':description2, 'href':href2},
            {'libelle':msg3, 'icone':icone3, 'title':description3, 'href':href3}
            ]

def get_share_menu(server_nb, name=None):
    """ renvoit le menu partage de l'api"""
    msg1 = 'Créer'
    msg2 = 'Modifier'
    msg3 = 'Supprimer'
    description1 = 'Créer un partage'
    description2 = 'Modifier un partage'
    description3 = 'Supprimer un partage'
    icone1 = '/image/share.gif'
    icone2 = '/image/modify_share.gif'
    icone3 = '/image/supprimer_share.gif'
    if name != 'gestion_share_create':
        href1 = make_js_link(server_nb, 'gestion_share_create')
    else:
        href1 = ''
    if name != 'gestion_share_modify':
        href2 = make_js_link(server_nb, 'gestion_share_modify')
    else:
        href2 = ''
    if name != 'gestion_share_suppr':
        href3 = make_js_link(server_nb, 'gestion_share_suppr')
    else:
        href3 = ''
    return [{'libelle':msg1, 'icone':icone1, 'title':description1, 'href':href1},
            {'libelle':msg2, 'icone':icone2, 'title':description2, 'href':href2},
            {'libelle':msg3, 'icone':icone3, 'title':description3, 'href':href3}
            ]

def get_account_menu(server_nb):
    """ renvoit le menu compte machine de l'api"""
    msg3 = 'Supprimer'
    description3 = 'Supprimer un compte machine'
    icone3 = '/image/del_account.gif'
    href3 = make_js_link(server_nb, 'gestion_account_suppr')
    return [{'libelle':msg3, 'icone':icone3, 'title':description3, 'href':href3}
            ]

def get_group_menu(server_nb, name=None):
    """ renvoit le menu de l'api"""
    msg1 = 'Créer'
    msg2 = 'Modifier'
    msg3 = 'Supprimer'
    description1 = 'Créer un groupe'
    description2 = 'Modifier un groupe'
    description3 = 'Supprimer un groupe'
    icone1 = '/image/group.gif'
    icone2 = '/image/modify_group.gif'
    icone3 = '/image/supprimer_group.gif'
    if name != 'gestion_group_create':
        href1 = make_js_link(server_nb, 'gestion_group_create')
    else:
        href1 = ''
    if name != 'gestion_group_modify':
        href2 = make_js_link(server_nb, 'gestion_group_modify')
    else:
        href2 = ''
    if name != 'gestion_group_suppr':
        href3 = make_js_link(server_nb, 'gestion_group_suppr')
    else:
        href3 = ''
    return [{'libelle':msg1, 'icone':icone1, 'title':description1, 'href':href1},
            {'libelle':msg2, 'icone':icone2, 'title':description2, 'href':href2},
            {'libelle':msg3, 'icone':icone3, 'title':description3, 'href':href3}
            ]

def _get_dds():
    """ renvoit la liste des lettres de disque disponible """
    letters = ['%s:'%letter for letter in ascii_uppercase]
    return letters

def get_return_btn(server_nb):
    """ renvoit le bouton de retour au menu principal de la partie gestion
    """
    return_btn = {}
    return_btn['href'] = make_js_link(server_nb,'gestion_index')
    return_btn['icone'] = "/image/back.png"
    return_btn['libelle'] = "Retour"
    return_btn['title'] = "Retour au menu de gestion"
    return return_btn
