#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import xmlrpc.client, urllib.request, urllib.parse, urllib.error
import cmd
from ead2.frontend.console import eadcmd
from ead2.frontend.console.libconsole import *
from ead2.config.config import AUTH_SERVER
import ead2.lib.i18n_frontend_console

class Console(cmd.Cmd, eadcmd.Ead):
    """
    Définition et configuration générique d'une console 
    """
    def __init__(self):
        cmd.Cmd.__init__(self)
        self.doc_header = _("documented commands (type help <command>):")
        self.prompt = "=>> "
        self.intro  = _("Administration tool EAD")+'\n'+_("(type help or ? for command list)")

        # lancement des utilitaires qui stockent les questions
        eadcmd.Ead.__init__(self,AUTH_SERVER)

    ## Override methods in Cmd object ##
    def preloop(self):
        """Initialization before prompting user for commands.
        Despite the claims in the Cmd documentaion, Cmd.preloop() is not a stub.
        """
        cmd.Cmd.preloop(self)   ## sets up command completion
        self._hist    = []      ## No history yet
        self._locals  = {}      ## Initialize execution namespace for user
        self._globals = {}

    def postloop(self):
        """Take care of any unfinished business.
           Despite the claims in the Cmd documentaion, Cmd.postloop() is not a stub.
        """
        cmd.Cmd.postloop(self)   ## Clean up command completion
        print(_("Console exit"))

    def precmd(self, line):
        """ This method is called after the line has been input but before
            it has been interpreted. If you want to modifdy the input line
            before execution (for example, variable substitution) do it here.
        """
        self._hist.append(line.strip())
        return line

    def postcmd(self, stop, line):
        """If you want to stop the console, return something that evaluates to true.
           If you want to do some post command processing, do it here.
        """
        return stop
    
    def emptyline(self):    
        """Do nothing on empty input line"""
        print(_("Type 'exit' to end the session or type ? for help."))

    def default(self, line):       
        """Called on an input line when the command prefix is not recognized.
           In that case we execute the line as Python code.
        """
        if line == 'EOF':
            return self.do_exit(None)
        else:
            print(_("*** Unknown syntax : %s (type help for a list of valid commands)")%line)

    
    ## Command definitions to support Cmd object functionality ##
    def do_hist(self, args):
        """Print a list of commands that have been entered"""
        print(self._hist)


    def do_exit(self, args):
        """Exits from the console"""
        return -1

    def EOF(self, args):
        """Exit on system end of file character"""
        return self.do_exit(args)

    def do_help(self, args):
        """
        Aide sur les commandes.
        'help' ou '?' sans arguments renvoie une liste de commandes
        pour lesquelles une aides est disponible.
        'help <command>' ou '? <command>' renvoie l'aide sur la commande <command>
        """
        ## The only reason to define this method is for the help text in the doc string
        cmd.Cmd.do_help(self, args)


if __name__ == '__main__':
    try:
        console = Console()
    except (KeyboardInterrupt, EOFError):
        import sys
        sys.exit('\n'+_("Keyboard interruption"))
    first = True
    #pour catcher control-C pour que cela ne quitte pas inopinement
    while 1:
        try:
            if first:
                console.cmdloop()
            else:
                console.cmdloop("")
            break
        except (KeyboardInterrupt,EOFError):
            first=False
