#-*-coding:utf-8-*-
""" gestionnaire d'ajout - suppression d'utilisateur """
from twisted.python import log
from ead2.backend.actions import tools
from amon.dansguardian import dans_tools, config # import set_policy, get_policies, unset_policy
from ead2.backend.actions.amon.groupe_form import policies_libelles

## code couleur pour les utilisateurs spéciaux
policies_colors = {2:'#cfffba', 3:'#ffaeae', 4:'#ffffff'}

## interface -> navigation_user.py -> user.py (formulaire, action) -> dansguardian
libelles = {'add':"Login de l'utilisateur à gérer sur le filtre web %s"}
zone_indices = {'admin':0, 'pedago':1}

messages = {'mod':"L'utilisateur %s est désormais %s.",
            'del':"La référence à l'utilisateur %s a été supprimée.",
            'add':"L'utilisateur %s est désormais référencé."
            }

## formulaire
def add_form(zone):
    """
        renvoie les données pour lamise en forme du formulaire d'ajout d'utilisateur
    """
    user = {'name':'name', 'libelle': libelles['add'] % (zone_indices[zone]+1),
                    'onblur':"testVoid('name', 'error_name')",}
    return dict(username = user)

def get_users(zone_indice):
    """
        renvoie la liste triée des utilisateurs configurés niveau dansguardian
    """
    if type(zone_indice) != int:
        zone_indice = zone_indices[zone_indice]
    users = []
    for user_list in dans_tools.get_policies(zone_indice).values():
        users.extend(user_list)
    users.sort()
    return users

def get_color_code():
    """
        renvoie la liste des codes couleurs pour les utilisateurs spéciaux
    """
    return ((policies_colors[2], 'Modérateurs'),
            (policies_colors[3], 'Utilisateurs interdits'),
            (policies_colors[4], 'Utilisateurs en mode liste blanche')
            )

def get_list(zone, server_nb, action):
    """
        renvoie les données pour la mise en forme de la liste (tableau) des utilisateurs
    """
    zone_indice = zone_indices[zone]
    listing = []
    entete = ("Login des utilisateurs", "politique de filtrage", "suppression")
    for user in get_users(zone_indice):
        libelle = user
        user_policy = dans_tools.get_policy(zone_indice, user)
        select_policy = policy_form(zone, server_nb, action, user, user_policy)
        suppr_btn = _get_del_btn(server_nb, action, user)
        if user_policy in policies_colors.keys():
            listing.append((libelle, select_policy, suppr_btn, policies_colors[user_policy]))
        else:
            listing.append((libelle, select_policy, suppr_btn, ''))
    return dict(user_list=listing,
                entete=entete,
                color_code=get_color_code(),
                )

def policy_form(zone, server_nb, action, user, user_policy):
    """
        renvoie la description du formulaire
        de choix de la politique de filtrage à appliquer sur le user user
    """
    options = [{'name': str(policy), 'libelle': policies_libelles[policy-1]}for policy in config.policies]
    if user_policy:
        options[user_policy-1]['default'] = 'ok'
    select_policy = {'onchange':tools.make_js_link(server_nb, action, code=True, balise="user_msg",
                                                    policy='this.options[this.selectedIndex].value',
                                                    user="'%s'"%user),
                     'name':'select_policy',
                     'options':[{'name':'', 'options':options}]}
    return select_policy

def _get_del_btn(server_nb, action, user):
    """
        renvoie la description du bouton de suppression pour l'utilisateur user
    """
    href = tools.make_js_link(server_nb, action, todel=user)
    title = "Supprimer la référence à l'utilisateur %s"%user
    icone = "/image/supprimer.gif"
    _class = "amon_user_del_btn"
    return dict(libelle="", href=href, title=title, icone=icone, _class=_class)

def get_validate(server_nb, name):
    """
        renvoie la description du bouton de validation du formulaire de creation d'utilisateur
    """
    href = tools.make_form_link(server_nb, name, True, ['create_user'], 'user_msg')
    title = "Ajout de la référence à l'utilisateur"
    icone = "/image/ok.gif"
    libelle = "Valider"
    inline = 'ok'
    return dict(href=href,
                title=title,
                icone=icone,
                libelle=libelle,
                inline=inline)

## Action
def add_user(zone, result):
    """
        ajoute login dans le filtergrouplist de la zone zone
        en le configurant sur la politique par défaut
    """
    zone_indice = zone_indices[zone]
    login = result['name']
    if not tools.test_login(login):
        raise Exception, 'Le login ne doit contenir que les caratères de a à z, de 0 à 9 et -_.'
    if login in get_users(zone_indice):
        raise Exception, 'Ce login est déjà référencé.'

    dans_tools.set_policy(zone_indice, 1, login, _type='user')
    message = messages['add']%(login)
    return dict()#message = message)

def del_user(zone, login):
    """
        supprime la référence au user login dans le filtergrouplist de la zone zone
        et redémarre dansguardian
    """
    zone_indice = zone_indices[zone]
    if not tools.test_login(login):
        raise Exception, 'Le login ne doit contenir que les caratères de a à z, de 0 à 9 et -_.'

    dans_tools.unset_policy(zone_indice, login, _type='user')
    message = messages['del']%(login)

    if dans_tools.reload():
        message += "\\nLe filtre a bien été rechargé."
    else:
        log.err("Erreur au lancement de /etc/init.d/dansguardian reload(1) dans user.py")
        raise Exception, "%s\\n Erreur au rechargement du filtre."%message
    return dict()#message = message)

def mod_user(zone, policy, login):
    """
        modifie la politique à appliquer à l'utilisateur login
        et redémarre dansguardian
    """
    zone_indice = zone_indices[zone]
    if type(policy) == str:
        policy = int(policy)
    if policy not in config.policies:
        raise Exception, "Erreur d'indice pour la politique à appliquer."

    if not tools.test_login(login):
        raise Exception, 'Le login ne doit contenir que les caratères de a à z, de 0 à 9 et -_.'

    dans_tools.set_policy(zone_indice, policy, login, _type='user')
    message = messages['mod']%(login, policies_libelles[policy-1])

    if dans_tools.reload():
        message += "\\nLe filtre a bien été rechargé."
    else:
        log.err("Erreur au lancement de /etc/init.d/dansguardian reload(1) dans user.py")
        raise Exception, "%s\\n Erreur au rechargement du filtre."%message

    return dict(message = message)

