# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Gère les rôles utilisateurs de l'Ead2
#
###########################################################################
"""
    gestionnaire des rôles utilisateurs
"""
from twisted.python import log
from ead2.backend.config.filenames import role_filename, perm_filename, ldapkeys_filename
from os.path import isfile, join
from sets import Set
from glob import glob
from ead2.backend.config.config import EOLE_MODULE, CONFIG_DIR
from ead2.backend.lib.perm.parser import RoleParser, PermissionParser, Role, parse_and_update
from ConfigParser import ConfigParser

f_roles = RoleParser()
f_roles.parse_file(role_filename)
perms_p = PermissionParser()
perms_p.parse_file(perm_filename)

from ead2.backend.lib.eadserver import load_actions
from ead2.backend.lib.perm.registry import PermissionManager

# listing des noms de fichiers de permissions disponibles
action_filenames = [f_name for f_name in [join(CONFIG_DIR, 'perm.ini'),
                    join(CONFIG_DIR, 'perm_%s.ini' % EOLE_MODULE)] if isfile(f_name)]
action_filenames.extend(glob(join(CONFIG_DIR, 'perms', '*.ini')))
action_parser = PermissionParser()
action_parser.read(action_filenames)
action_list = action_parser.get_permissions().keys()

# actions obligatoires pour chaque rôle
#FIXME : gérer les actions obligatoires : OK
mandatory_actions = ['main_status', 'update_ead', 'help']

# noms des fichiers de permissions du module
#perm_files = ['/usr/share/ead2/backend/config/perm.ini',
#              '/usr/share/ead2/backend/config/perm_%s.ini' % module, perm_filename]
perm_files = [f_name for f_name in action_filenames]
perm_files.append(perm_filename)

def get_ldapkeys():
    """
        renvoie les clés ldap et leur libelle pour l'association de rôles
    """
    if isfile(ldapkeys_filename):
        return [(val.split('#')[0], val.split('#')[1])for val in file(ldapkeys_filename).read().splitlines()]
    else:
        return [("Divcod", "Classe associée à l'utilisateur"),
                ("typeadmin", "Valeur de la clé typeadmin"),
                ("uid", "Login de l'utilisateur"),
                ('user_groups', "Groupe de l'utilisateur"),
               ]

#FIXME : grouper les actions

def get_actions():
    """
        renvoie la liste des actions disponibles sur le module
    """
    actions = [action for action in action_list if action not in mandatory_actions]
    actions.sort()
    return actions

def get_roles():
    """
        renvoie les rôles de l'ead2
    """
    roles = []
    for f_perm in perm_files:
        if isfile(f_perm):
            role_manager = RoleManager(f_perm)
            roles.extend([(role, role_manager.get_libelle(role))
                                    for role in role_manager.get_roles() if (role, role_manager.get_libelle(role)) not in roles])
    return roles

def get_libelle(role):
    """
        renvoie le libelle du role role
    """
    for name, libelle in get_roles():
        if name == role:
            return libelle
    raise Exception, "Le libellé du rôle %s n'a pas été retrouvé."%role

def get_optionnal_user_roles(username):
    """
        renvoie les rôles optionnels définis pour username
    """
    m = UserRoleManager()
    role = m.get_user_role(username)
    return role


class RoleManager(PermissionParser):
    """
        gère les rôles pour l'ead2
        ecriture de perm_local.ini
    """

    def __init__(self, filename=perm_filename):
        PermissionParser.__init__(self)
        self.filename = filename
        self.read(self.filename)
        if not isfile(filename):
            self.add_section('roles')
            self.add_section('permissions')
            self.save()

    def is_role(self, rolename):
        return rolename in self.get_roles()

    def get_roles(self):
        """
            renvoie la liste des roles
        """
        if not self.has_section('roles'):
            return []
        return [name for name, descr in self.items('roles')]

    def get_libelle(self, role):
        """
            renvoie le libelle d'un rôle
        """
        for name, descr in self.items('roles'):
            if name == role:
                return descr
        raise Exception, "Le rôle %s n'est pas référencé."%role

    def get_permissions(self):
        """
            renvoie la liste des permissions définies dans le .ini
        """
        if not self.has_section('permissions'):
            return {}
        return dict([(action_name, [role.strip() for role in roles.split(',')if roles!=[]])for action_name, roles in self.items('permissions')])

    def get_role_perms(self, role):
        """
            renvoie la liste des permissions pour le role role
        """
        return [name for name, roles in self.get_permissions().items() if role in roles and name not in mandatory_actions]

    def set_role_perms(self, rolename, actionnames):
        act_actions = self.get_role_perms(rolename)
        for action in act_actions:
            if action not in actionnames+mandatory_actions:
                self.del_role_perm(rolename, action)
        self.add_role_perm(rolename, actionnames)
        return True

    def add_role_perm(self, rolename, actionnames):
        """
            associe une action à un rôle
        """
        #FIXME : tester l'existence de l'action
        if rolename not in self.get_roles():
            raise Exception, "Erreur: ce rôle n'existe pas."
        if not hasattr(actionnames, '__iter__'):
            actionnames = [actionnames]
        for actionname in actionnames:
            if actionname not in action_list:
                raise Exception, "L'action %s n'est pas référencée."%actionname
            if self.has_option('permissions', actionname):
                if rolename not in self.get_permissions()[actionname]:
                    rolenames = self.get_permissions()[actionname]
                    rolenames.append(rolename)
                    self.remove_option('permissions', actionname)
                    self.add_perm('permissions', actionname, rolenames)
            else:
                self.add_perm('permissions', actionname, rolename)
        self.save()
        return True

    def add_perm(self, section, option, value):
        """
            ajoute une permission
        """
        if type(value) == str:
            value = [value]
        if value == [] or value == ['']:
            return False
        self.set('permissions', option, ','.join(value))
        return True

    def add_role(self, rolename, rolelibelle):
        """
            ajoute un role au fichier de permission
        """
        rolename = rolename.lower()
        if self.has_option('roles', rolename):
            raise Exception, "Erreur : le rôle %s existe déjà."%rolename
        self.set('roles', rolename, rolelibelle)
        self.add_role_perm(rolename, mandatory_actions)
        self.save()
        return True

    def del_role(self, rolename):
        """
            supprime un rôle
        """
        self.del_role_perms(rolename)
        if self.remove_option('roles', rolename):
            self.save()
            return True
        raise Exception, "Erreur: ce rôle n'existe pas."

    def del_role_perms(self, role):
        """
            supprime les permissions du role role
        """
        for actionname in self.get_role_perms(role)+mandatory_actions:
            self.del_role_perm(role, actionname)
        return True

    def del_role_perm(self, role, actionname):
        """
            supprime la permission pour actionname du role role
        """
        rolenames = self.get_permissions()[actionname]
        rolenames.remove(role)
        self.remove_option('permissions', actionname)
        if rolenames != []:
            self.add_perm('permissions', actionname, rolenames)
        self.save()
        return True

    def save(self):
        """
            écrit le fichier de permissions
        """
        f_perm = file(self.filename, 'w')
        self.write(f_perm)
        f_perm.close()

class UserRoleManager(ConfigParser):
    """
        gère l'attribution de rôle à un user (écriture d'un role_local.ini)
    """

    def __init__(self, filename=role_filename):
        ConfigParser.__init__(self)
        self.filename = filename
        self.read(self.filename)

    def get_sections(self):
        """
            renvoie les rôles configurés
        """
        return dict([(section, dict([(item[0], item[1]) for item in self.items(section)]))
                                for section in self.sections()])

    def remove_association(self, ldapkey, ldapvalue, role):
        """
            supprime un lien entre une clé ldap et un rôle
        """
        self.del_autorization(ldapkey, ldapvalue)
        self.save()

    def get_user_role(self, username):
        """
            renvoie les rôles pour le user username
        """
        if self.has_section('uid'):
            users = self.get_sections()['uid']
        else:
            return []
        roles = []
        for user, role in users.items():
            if username == user:
                roles.append(role)
        return roles

    def get_autorizations(self, called_role):
        """
            renvoie les définitions d'autorisations pour rôle
        """
        if called_role is None:
            return self.get_sections()

        return_dict = {}
        for ldapkey, values in self.get_sections().items():
            if called_role:
                for ldapvalue, role in values.items():
                    if role == called_role:
                        return_dict[ldapkey] = ldapvalue
        return return_dict

    def add_users_role(self, role, users):
        """
            associe des utilisateurs à un role
        """
        if not role in [name for name, descr in get_roles()]:
            raise Exception, "Le rôle %s n'existe pas."%role

        if not hasattr(users, '__iter__'):
            users = [users]
        for user in users:
            self.add_role_key('uid', user, role)
        return True

    def add_role_key(self, ldapkey, ldapvalue, role):
        """
            crée une entrée de définition d'un role
            @ldapkey : clé à évaluer
            @ldapvalue : valeur de la clé
            @role : rôle associé
        """
        if not self.has_section(ldapkey):
            self.add_section(ldapkey)

        if self.has_option(ldapkey, ldapvalue):
            #FIXME : gérer plusieurs rôles pour une clé ?
            self.remove_option(ldapkey, ldapvalue)

        self.set(ldapkey, ldapvalue, role)
        self.save()
        return True

    def del_role_autorizations(self, role):
        """
            supprime les autorisations pour le rôle role
        """
        for ldapkey, ldapvalue in self.get_autorizations(role).items():
            self.del_autorization(ldapkey, ldapvalue)
        self.save()

    def del_autorization(self, ldapkey, ldapvalue):
        """
            supprime une autorisation associé à la valeur ldapvalue pour la clé ldapkey
        """
        #FIXME : gérer plusieurs rôles pour une clé ?
        self.remove_option(ldapkey, ldapvalue)
        if self.get_sections()[ldapkey].keys() == []:
            self.remove_section(ldapkey)

    def save(self):
        """
            écrit le fichier de permissions
        """
        f_role = file(self.filename, 'w')
        self.write(f_role)
        f_role.close()
