# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
#Test du module de gestion de profils
#
###########################################################################
""" teste role_editor_tools.py """
import autopath
from ead2.backend.actions.lib.profils import role_editor_tools as r
import os

def test_get():
    """ teste les méthodes get """
    m = r.RoleManager('/usr/share/ead2/backend/actions/lib/profils/tests/datas/perm.ini')
    assert m.get_roles() == ['role1', 'role2']
    assert m.get_permissions() == {'action1':['role1', 'role2'], 'action2':['role1']}
    assert m.get_role_perms('role1') == ['action1', 'action2']

def test_add_role():
    """ teste add_role et del_role """
    perm_filename = '/usr/share/ead2/backend/actions/lib/profils/tests/datas/perm_test.ini'
    if os.path.isfile(perm_filename):
        os.remove(perm_filename)
    m = r.RoleManager(perm_filename)
    m.add_role('role1', 'role test 1')
    m.add_role('role2', 'role test 2')
    m.add_role_perm('role1', 'journal')
    assert m.get_roles() == ['role1', 'role2']
    m.del_role('role1')
    assert m.get_roles() == ['role2']

def test_add_perm_role():
    """ teste add_role_perm et del_role_perm """
    perm_filename = '/usr/share/ead2/backend/actions/lib/profils/tests/datas/perm_test.ini'
    if os.path.isfile(perm_filename):
        os.remove(perm_filename)
    m = r.RoleManager(perm_filename)
    m.add_role('role1', 'role test 1')
    m.add_role('role2', 'role test 2')
    m.add_role_perm('role1', 'journal')
    assert m.get_role_perms('role1') == ['journal']
    m.del_role_perms('role1')
    assert m.get_role_perms('role1') == []

