# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# Action UpdateEad 
#  
# Action permettant de lister les fichiers web(script, style et image)
# manquant au frontend
#       
###########################################################################
from twisted.python import log
from nevow.url import URL
from ead2.backend.lib.action import * 
from ead2.lib.libead import uni
from os import path as osp
from os import listdir
from ead2.backend.config.config import SCRIPT_DIR, DOWNLOAD_DIR
import sets
from os.path import isdir

class UpdateEad(Action):
    """flag de mise a jour de l'ead 
       cette action est specifique et lancee au moment de la connexion a un serveur
    """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'update_ead'
    # pas de categorie
    category = None
    description = 'mise a jour ead'
    libelle = "outil de gestion de cache"
    script = Text(default='[]', doc='liste des scripts presents cote frontend')
    style = Text(default='[]', doc='liste des styles presents cote frontend')
    image = Text(default='[]', doc='liste des images presentes cote frontend')

    def execute(self):
        """
        - lecture d'un fichier de version de l'ead existant
        - comparaison avec la revision du serveur
        :return: True or False
        """
        try:
            act_scripts = eval(self.script)
            act_scripts = self.clear_scripts(act_scripts)
            act_styles = eval(self.style)
            act_styles = self.clear_styles(act_styles)
            act_images = eval(self.image)
            act_images = self.clear_images(act_images)
        except:
            act_scripts = []
            act_styles = []
            act_images = []
            log.err("Une erreur est survenue au listing de fichier dans update_ead")
        # on compare la liste des fichiers présents cote frontend avec ceux du backend
        here_scripts, here_styles, here_images = [[],[],[]]
        if isdir(osp.join(DOWNLOAD_DIR, 'script')): here_scripts = self.clear_scripts(listdir(osp.join(DOWNLOAD_DIR, 'script')))
        if isdir(osp.join(DOWNLOAD_DIR, 'style')): here_styles = self.clear_styles(listdir(osp.join(DOWNLOAD_DIR, 'style')))
        if isdir(osp.join(DOWNLOAD_DIR, 'image')): here_images = self.clear_images(listdir(osp.join(DOWNLOAD_DIR, 'image')))
        result = {}
        result['script'] = self.compare(here_scripts, act_scripts)
        result['style'] = self.compare(here_styles, act_styles)
        result['image'] = self.compare(here_images, act_images)
        return 0, uni(str(result))

    def compare(self, a, b):
        """ compare le contenu de deux listes :a: et :b: et renvoit la différence u-v"""
        u = sets.Set(a)
        v = sets.Set(b)
        missing = list(u-v)
        return missing

    def clear_images(self, images):
        """ nettoie le listdir afin de ne conserver que les images """
        result = []
        for i in images:
            if i[-3:].lower() in ['gif', 'jpg', 'png']:
                result.append(i)
            elif i[-4:].lower() == 'jpeg':
                result.append(i)
        return result
    
    def clear_styles(self, styles):
        """ nettoie le listdir afin de ne conserver que les styles """
        result = []
        for i in styles:
            if i[-3:].lower() == 'css':
                result.append(i)
        return result
    
    def clear_scripts(self, scripts):
        """ nettoie le listdir afin de ne conserver que les scripts """
        result = []
        for i in scripts:
            if i[-2:].lower() == 'js':
                result.append(i)
        return result           
