# -*- coding: utf-8 -*-
""" renvoit l'affichage d'une action """
import socket

from twisted.python import log
import json
from nevow import loaders, tags as T, rend, inevow

from ead2.frontend.web.config import ENCODING
from ead2.frontend.web.lib.urls import EadUrl
from ead2.frontend.web.gabarit import format_action
from ead2.frontend.web.config import ACTION_SOCKET_TIMEOUT
from ead2.lib.libead import parcour_dico

def encode_str(mystring):
    try:
        return mystring.decode('iso-8859-15').encode('utf-8')
    except:
        return mystring

class Action(rend.Page):
    """ gere les actions :
        :action_name: nom de l'action
        :menu: menu de description des actions disponibles
    """
    docFactory = loaders.xmlstr('''
            <div xmlns:nevow="http://nevow.com/ns/nevow/0.1">
                       <span nevow:render='action'/>
                       </div>
                       ''')

    def __init__(self, action_name, menu, ctx):
        self.ctx = ctx
        self.action = action_name
        self.actions = menu["actions"]
        self.menu = menu["menu"]

    def render_action(self, ctx, data):
        """ rend le formulaire pour une action """
        try:
            self.description = self.actions[self.action][0].encode(ENCODING)
            self.params = self.actions[self.action][1]
        except KeyError:
            return ""
            return T.center()[T.img(src='/image/forbidden.png')]
        session = inevow.ISession(self.ctx)
        request = inevow.IRequest(self.ctx)
        url = str(EadUrl.fromContext(self.ctx))
        try:
            url = url.split('/')[2].split(':')[0]
        except:
            url = url
        key = None
        request.args = parcour_dico(request.args, encode_str)
        # si on revient d'un formulaire on evalue les donnees ecrites en Json
        if 'JSONstr' in request.args.keys():
            try:
                result = json.loads(request.args['JSONstr'][0])
                key = result.keys()[0]
                return_res = result[key]
                request.args.pop('JSONstr')
            except:
                log.err()
                log.err( "Erreur de structure du param de type JSON dans la requête")
                key = None
                request.args.pop('JSONstr')
                return T.script["window.alert('Votre entrée de formulaire n\\'est pas conforme et ne peut être traitée.')"]
        # pour tout plugin on renvoit et les args de la requete afin qu il gere sa propre url
        params = {'request':request.args}
        # si on a des parametres JSON dans la requete on les renvoient
        if key is not None:
            params.update({key:return_res})
        # on renvoie l'url à  l'action
        params.update({'url':url})
        magic_nb = session.magic_number
        socket.setdefaulttimeout(ACTION_SOCKET_TIMEOUT)
        log.msg("####   Envoie au backend de la requête pour l'action %s " % self.action)
        try:
            return_code, data = session.ead_server.execute_action(unicode(self.action), params, magic_nb)
            if return_code == 0:
                log.msg("++++ Retour d'action ok")
                return format_action(data, session.ead_server, magic_nb)
            else:
                log.err("---- Retour d'action négatif")
                log.err(data)
                return T.div()[T.img(src='image/warning.png'),
                               T.br(),
                               T.b["Le backend a renvoyé une erreur lors de l'exécution de la requête :"],
                               T.br(),
                               T.b[data.encode('UTF-8')]]
        except socket.sslerror:
            log.err("---- Une requête trop longue n'a pas pu aboutir.")
            return T.div[
                             T.img(src='image/warning.png'),
                             T.br(),
                             T.b["Erreur rencontrée : aucune réponse du backend:"],T.br(),
                             "La connexion frontend-backend a été interrompue suite à un délai d'attente trop long.",
                             T.script()[
                            "window.alert('La requête est trop longue, le résultat ne peut être affiché');"
                            ]
                         ]
        except:
            log.err()
            log.err("---- Une erreur a été rencontrée lors de l'éxécution de la requête")
            return T.div()[
                           T.img(src='image/warning.png'),
                           T.br(),
                           T.b["Une erreur a été rencontrée lors de la requête"]
                          ]
