# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Utilitaires pour les gestionnaires de connexion d'horus
#
###########################################################################
""" outil pour l'application isis """
import commands
from os.path import join
from ead2.backend.actions.tools import make_js_link, make_form_link

## les machines
def get_active_workstations():
    """ renvoit les stations connectées
    """
    _list = []
    code, result = commands.getstatusoutput('/usr/bin/findsmb')
    if code == 0:
        workstations = parse_findsmb(result)
        for workstation in workstations:
            _list.append(parse_workstation(workstation))
    return _list

def parse_findsmb(string):
    """ parse les descriptions des machines depuis findsmb"""
    lines = string.splitlines()
    for line in lines:
        if '-------' in line:
            num = lines.index(line)+1
            lines = lines[num:]
    return lines

def parse_workstation(string):
    """ parse les descriptions d'une machine
        'ip , netbiosname ,type, nom, systeme'
    """
    workstation = {}
    attrs = string.split()
    workstation['ip'] = attrs[0]
    workstation['netbiosname'] = attrs[1]
    fin = attrs[2:]
    fin = "".join(fin).split('[')
    workstation['_type'] = fin[0]
    workstation['nom'] = fin[1].split(']')[0]
    if len(fin)>2 :
        workstation['systeme'] =  fin[2].split(']')[0]
    else:
        workstation['systeme'] = "undefined"
    return workstation

def list_valid_workstations(_type = None):
    """ renvoit les machines connectées au réseau
        :_list: list de dico décrivant les machines
    """
    keys = {'controleur':'*',
            'maitre':'+'}
    result = []
    machines = get_active_workstations()
    if _type in keys.keys():
        for machine in machines:
            if machine['_type'] == keys[_type]:
                result.append(machine)
        return result
    else:
        return machines

def parse_smbstatus(string):
    """ parse la commande smbstatus
        :return: liste de dico decrivant les utilisateurs ainsi
                    que tous les services et fichiers qui leur sont associés
                    None par défaut
    """
    sections = string.split('ocked files')
    users_section = sections[0]
    if len(sections) == 2: #on a des fichiers ouverts
        activity_section = sections[1]
    else:
        activity_section = None
        activity = None
    users = parse_smbstatus_users(users_section)
    if users is not None:
        if activity_section:
            activity = parse_smbstatus_files(activity_section)
        if activity:
            users = associate_users_and_files(users, activity)
        else:
            for user in users:
                user['files'] = None
        return users
    return []

def associate_users_and_files(users, activity):
    """ associe les utilisateurs et leur fichier en activité"""
    for user in users:
        user['files'] = []
        for f in activity:
            if (f['pid'] == user['pid']) and (f not in user['files']):
                user['files'].append(f)
    return users

def parse_smbstatus_files(string):
    """ parse la section des fichiers actifs (action en cour) """
    file_sect = string.splitlines()
    files_str = ''
    for i, line in enumerate(file_sect):
        if '----------' in line:
            files_str = file_sect[(i+1):]
            break
    fichiers = []
    if files_str == '':
        return None
    for file_str in files_str:
        file_tab = file_str.split()
        filenames = []
        if file_tab != []:
            fichier = {}
            fichier['pid'] = file_tab[0]
            fichier['uid'] = file_tab[1]
            fichier['denymode'] = file_tab[2]
            fichier['access'] = file_tab[3]
            fichier['rw'] = file_tab[4]
            fichier['oplock'] = file_tab[5]
            fichier['sharepath'] = file_tab[6]
            fic = ' '.join(file_tab[7:-5])
            if fic == '.':
                fichier['nom'] = fichier['sharepath']
            else:
                fichier['nom'] = join(fichier['sharepath'], fic)
            if fichier['nom'] not in filenames:
                fichiers.append(fichier)
                filenames.append(fichier['nom'])
    if fichier == []:
        return None
    return fichiers

def parse_smbstatus_users(string):
    """ parse la section utilisateurs de smbstatus (deux parties)"""
    users_sect = string.splitlines()
    # on sépare les deux parties
    for i, line in enumerate(users_sect):
        if '----------' in line:
            result = users_sect[(i+1):]
            break
    for i, line in enumerate(result):
        if '----------' in line:
            part1 = result[:(i-1)]
            part2 = result[(i+1):]
            break
    # on récupère tous les utilisateurs
    users = []
    for i in part1:
        user_table = i.split()
        if user_table != []:
            user = {}
            user['pid'] = user_table[0]
            user['nom'] = user_table[1]
            user['group'] = user_table[2]
            user['machine'] = user_table[3]
            ip = user_table[4]
            if ip[0] == '(':
                ip = ip [1:]
                ip = ip[:-1]
            user['ip'] = ip
            users.append(user)
    if users == []:
        return None
    services = []
    for i in part2:
        user_table2 = i.split()
        if len(user_table2) >4:
            service = {}
            service['service'] = user_table2[0]
            service['pid'] = user_table2[1]
            service['machine'] = user_table2[2]
            fin = user_table2[3:]
            fin = "".join(fin)
            service['timeconnect'] = fin
            services.append(service)
    # on associe les services à leur propriétaire
    for user in users:
        user['services'] = []
        for service in services:
            if user['pid'] == service['pid']:
                user['services'].append(service)
        if user['services'] == []:
            user['services'] = None
    return users

def get_menu(server_nb, page='index', extended=False):
    """ rend le menu pour l'accueil de l'application isis
        :page: la page qui demande le menu
        :extended: rajoute les liens pour gerer les utilisateurs connectes
                   (envoi de message et deconnexion)
    """
    mail = {'href':make_form_link(server_nb, 'isis_sendmsg',
                                  True, ['isis_index']),
            'libelle':'Message', 'icone':'/image/mail.gif',
            'title':'Envoyer un message'}
    disconnect = {'href':make_form_link(server_nb, 'isis_disconnect',
                                        True, ['isis_index' ]),
                  'libelle':'Déconnecter', 'icone':'/image/deconnecter.gif',
                  'title':'Déconnecter et désactiver'}
    stop = {'href':make_js_link(server_nb, 'isis_stop'), 'libelle':'Stop',
            'icone':'/image/arreter.gif',
            'title':"Déconnecter et désactiver tous les utilisateurs"}
    login = {'href':make_js_link(server_nb, 'isis_login'), 'libelle':'Login',
                'icone':'/image/login.gif', 'title':"Activation des comptes"}
    refresh = {'href':make_js_link(server_nb, 'isis'), 'libelle':'Actualiser',
                'icone':'/image/refresh.gif',
                'title':"Rafraichir la liste des connectés"}
    index = {'href':make_js_link(server_nb, 'isis'),
             'libelle':'Connectés', 'icone':'/image/refresh.gif',
             'title':"Revenir à la liste des connectés"}
    if page == 'login':
        login['href'] = ''
    elif page == 'stop':
        stop['href'] = ''
    if page == 'index':
        if extended:
            return mail, disconnect, refresh, stop, login
        return refresh, stop, login
    return index, stop, login

def get_back_to_main(server_nb):
    """
    renvoie le bouton de retour
    vers la partie principale de l'application isis
    """
    hrefretour = make_js_link(server_nb, 'isis')
    retouricone = "/image/back.png"
    return {'href':hrefretour, 'icone':retouricone,
            'title':"Annuler", 'libelle':'Annuler'}

