# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
#
# Aide de l'ead
#
###########################################################################
""" Action d'affichage d'aide """
from twisted.python import log
from ead2.backend.lib.action import * # import des actions et des types
from ead2.backend.actions.tools import get_request, make_form_link
from ead2.backend.actions.tools import format_form_result
from ead2.lib.libead import uni
import urllib
from ead2.backend.config.config import HELP_DIR
from ead2.backend.config.help import help_templates
from os.path import join, isfile

def get_help(page=''):
    """
        renvoie le contenu de la page d'aide (écrite au format html)
    """
    if help_templates.has_key(page):
        filename = join(HELP_DIR, help_templates[page])
        if isfile(filename):
            f = file(filename, 'r')
            help = f.read()
            f.close()
            return help
    return "pas d'aide disponible"

class Help(Action):
    """ affiche une aide pour les actions en cours de traitement """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'help'
    libelle = "Aide"
    description = "Aide de l'Ead"
    category = None
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                                keys=['server', 'action', 'help', 'agent', 'help_page', 'squid'])

    def execute(self):
        """ renvoie les données pour la mise en forme de la page d'aide
            1 - renvoie les données pour afficher la page des agents
            2 - renvoie les données pour l'aide
        """
        params, self.server_nb = get_request(self.request)
        result = {'titre': self.description}
        ## 1 -
        if params.has_key('agent'):
            result['object'] = params['agent'][0]
            result['titre'] = "Agent de surveillance du service"
        if params.has_key('help_page'):
            result['help_page'] = get_help(params['help_page'][0])
        ## 3 -
        if params.has_key('squid'):
            result['object'] = params['squid'][0]
            result['titre'] = "STATISTIQUES SQUID"
        ## 2 -
        d = {'template':'aide', 'data':{'content':result}}
        return 0, uni(str(d))
