#! /usr/bin/env python
# -*- coding: iso-8859-1 -*-
#
# module de gestion des devoirs
# un devoir est :
#    distribu => ramass => rendu => purg (supprime les donnes)
#
# lorsque des donnes sont ajoutes au devoir, elles sont stockes dans
# \\scribe\devoirs\user\user-00001\donnees
# des liens sont ensuite crs lors de la distribution


import shutil, os, tempfile
#import win32api as wa

#import option
import traceback

from pbgest import CliPB
C = CliPB()
getrootobject, disconnect = C.getrootobject, C.disconnect

class GestDevoir:
    def __init__(self, username):
#        self.scribe = option.get_nom_scribe()
        self.username = username
        self.dev_dist_dir = os.path.join('/home','workgroups', 'devoirs', username)
        self.data_f = os.path.join(self.dev_dist_dir, 'devoirs.dat')
#        self.dev_dist_dir = '\\\\%s\\%s\\devoirs\\.distribues'%(self.scribe, self.username)

    def get_devs(self, num=None):
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("get_devoirs", self.username))
        d.addCallback(self.return_devs, num)
        return d

    def return_devs(self, devs, num):
        self.devs = devs
        return num

    def get_next_devname(self):
        """Renvoie le prochain nom de devoir disponible
        """
        # On veut le prochain
        devid = 0
        dev_name = '%s-%05.f'%(self.username, devid)
        while dev_name in self.devs.keys():
            devid += 1
            dev_name = '%s-%05.f'%(self.username, devid)
        # le dossier <login>-000X existe peut tre dj (si devoirs.dat a t supprim par ex.)
        while os.path.exists(os.path.join(self.dev_dist_dir, dev_name)):
            devid += 1
            dev_name = '%s-%05.f'%(self.username, devid)
        return dev_name

    ##################
    ## Distribution ##
    ##################
    def add_Fichs(self, flist, dst):
        """Ajoute les fichiers de la premire listeBox
        """
        if len(flist) == 0: return
        if not os.path.exists(dst):
            os.makedirs(dst)
        for i in flist:
            shutil.copy(i, dst)

    def copy_devoir(self, flist, dlist, dest_dev):
        """Copie des fichiers des listeBox "devoirs" et "donnes"
        dans dest_dev en passant par un rpertoire temporaire
        """
        dest_donnees = os.path.join(dest_dev, 'donnees')
        self.add_Fichs(flist, dest_dev)
        self.add_Fichs(dlist, dest_donnees)

    def distribute(self, flist, dlist, groupe, eleves_only=False, in_perso=True, dev_name=None):
        """distribue le contenu de self.arch dans les dossiers des membres du groupe "groupe"
        le nom de destination HOMEDIR/perso/Devoirs/nom_prof/dev_name
        si le dossier existe dj, il est pralablement supprim
        """
        if not dev_name:
            dev_name = self.get_next_devname()
##        self.dev_name = dev_name # pour l'affichage au retour de la distrib
        dest_dev = os.path.join(self.dev_dist_dir, dev_name)
        self.copy_devoir(flist, dlist, dest_dev)
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("distribute", groupe, dev_name, eleves_only, in_perso, self.username))
        d.addCallback(self.get_devs)
        d.addCallback(self.return_dist)
        return d

    def return_dist(self, num):
        disconnect()
        return num

    ###############
    ## Ramassage ##
    ###############
    def get_dist_devoirs(self):
        """retourne la liste des devoirs distribus non-ramasss
        """
        liste = []
        for dev_name in self.devs.keys():
            groupe = self.devs[dev_name]['groupe']
            etat = self.devs[dev_name]['state']
            if etat == 'dist': liste.append('%s - %s'%(dev_name, groupe))
        liste.sort()
        return liste

    def ramasse(self, dev):
        dev_name = dev.split(' - ')[0]
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("ramasse", dev_name, self.username))
        d.addCallback(self.get_devs)
        d.addCallback(self.return_ram)
        return d

    def return_ram(self, ret):
        disconnect()
        return ret

    #############
    ## Rendage ##
    #############
    def get_ram_devoirs(self):
        """retourne la liste des devoirs distribus non-ramasss
        """
        liste = []
        for dev_name in self.devs.keys():
            groupe = self.devs[dev_name]['groupe']
            etat = self.devs[dev_name]['state']
            if etat == 'ram': liste.append('%s - %s'%(dev_name, groupe))
        liste.sort()
        return liste

    def rendre(self, dev):
        dev_name = dev.split(' - ')[0]
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("rendre", dev_name, self.username))
        d.addCallback(self.get_devs)
        d.addCallback(self.return_ren)
        return d

    def return_ren(self, ret):
        disconnect()
        return ret

    #################
    ## Suppression ##
    #################
    def get_dev_todel(self):
        """Retourne la liste des devoirs dont les donnes sont tjrs sur le serveur
        """
        l = []
        if not os.path.exists(self.dev_dist_dir): return l
        for dev_name in os.listdir(self.dev_dist_dir):
            if dev_name.lower() == 'tmp': continue
            if os.path.isdir(os.path.join(self.dev_dist_dir, dev_name)):
                try: grp = self.devs[dev_name]['groupe']
                except:  grp = ''
                l.append('%s - %s'%(dev_name, grp))
        l.sort()
        return l

    def suppr(self, dev):
        dev_name = dev.split(' - ')[0]
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("supprimer", dev_name, self.username))
        d.addCallback(self.get_devs)
        d.addCallback(self.return_suppr)
        return d

    def return_suppr(self, ret):
        disconnect()
        return ret
