# -*- coding: UTF-8 -*-
from os import unlink
from os.path import isfile
from scribe.importation.config import AAF_LIST_EAD, RAPPORTFILE
from ead2.config.config import dico
from ead2.backend.actions import tools
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions.lib.widgets import ajax, form as F
from pyeole.process import system_out

# liste des templates complémentaires utilisés
USED_TEMPLATES = ['main', 'form', 'formselect', 'accordion']
LOG = '/tmp/synchro_aaf.log'
TMPL = 'scribe_synchro_aaf'

def get_aaf_files():
    """
    renvoie la liste des fichiers AAF à importer
    """
    aaf_files = []
    if isfile(AAF_LIST_EAD):
        aaf_list = file(AAF_LIST_EAD).read().strip()
        if aaf_list != '':
            aaf_files = aaf_list.split('\n')
    return aaf_files

def empty_file(filename):
    """
    écrase le fichier "filename"
    """
    fdesc = file(filename, "w")
    fdesc.close()

class SynchroAAF(Action):
    """
    Lancement de l'import des bases AAF synchnonisées
    """
    name = "scribe_synchro_aaf"
    category = "Outils"
    description = 'Synchronisation AAF'
    libelle = 'Synchronisation AAF'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'run_importation'])
    form_result = Dict(default={},
                       doc="Résultat de formulaire provenant du frontend.",
                       keys=['synchro'])


    def execute(self):
        """
        affichage des données
        """
        mode = dico['synchro_aaf']
        if mode == 'automatique':
            # cas 1 : mode automatique
            return_dict = {'msg':"La synchronisation AAF est configurée en mode <b>automatique</b>"}
        else:
            params, self.server_nb = tools.get_request(self.request)
            if not params.get('run_importation', ''):
                if not self.form_result.get('synchro', ''):
                    # affichage initial du formulaire
                    aaf_files = get_aaf_files()
                    if aaf_files == []:
                        # cas 2 : pas de fichiers
                        return_dict = self._no_aaf_files()
                    else:
                        # cas 3 : des fichiers sont disponibles
                        ss_titre = "La synchronisation AAF est configurée en mode <b>manuel</b>\n"
                        msg = "<i>Les fichiers suivants sont prêts à être importés</i><br/><br/>\n"
                        msg += "".join(["""<img src="/image/soleil_orange.png" width="15px" />
                                           %s<br/>""" % aaf_file for aaf_file in aaf_files])
                        annuel = F.Checkbox(name='annuel', inline=True, value='annuel')
                        annuel_libelle = "Importer les fichiers en mode \"annuel\""
                        return_dict = {'msg':msg,
                                       'ss_titre':ss_titre,
                                       'annuel':annuel,
                                       'annuel_libelle':annuel_libelle,
                                       'validate':self._get_valid_btn()}
                #elif not isfile(LOG):
                else:
                    # cas 4 : on lance l'import maj ou annuel
                    if tools.format_form_result(self.form_result['synchro']).has_key('annuel'):
                        mode = 'annuel'
                    else:
                        mode = 'maj'
                    self.form_result = {}
                    return_dict = self._runcmd(mode)
                #else:
                #    return_dict = {'msg':"Cas d'erreur"}
            else:
                # cas 5 : l'import est en cours
                return_dict = self._refresh_parse()
            return_dict['titre'] = self.description
        return self.send_all(return_dict, template=TMPL,
                             templates=USED_TEMPLATES)

    def _no_aaf_files(self):
        """
        La synchronisation est manuelle mais il n'y a aucun fichier à importer
        """
        ss_titre = "La synchronisation AAF est configurée en mode <b>manuel</b>"
        msg = "<br/><i>Aucun nouveau fichier n'est à importer</i>"
        return_dict = {'msg':msg, 'ss_titre':ss_titre}
        return return_dict

    def _runcmd(self, mode):
        """
        exécution de la commande
        """
        empty_file(LOG)
        cmd = []
        for aaf_file in get_aaf_files():
            cmd.append("/usr/bin/synchro_aaf %s %s" % (aaf_file, mode))
        cmd.append("echo '#FIN#' > %s" % LOG)
        cmds = ';'.join(cmd)
        system_out(['at', 'now'], stdin=cmds)
        empty_file(AAF_LIST_EAD)
        return_dict = {'message':"Lancement de l'importation",
                      'msg':"En préparation"}
        return_dict = self._refresh_parse_call(return_dict)
        return return_dict

    def _refresh_parse(self):
        """
            Renvoie la chaine d'éxécution pour
            le rafraichissement des logs du parsing
        """
        flag = ""
        if isfile(LOG):
            flag = file(LOG, "r").read()
            if isfile(RAPPORTFILE):
                content = file(RAPPORTFILE, "r").read()
                return_dict = {'rapport':'%s<br/><br/>' % content.replace('\n', "<br/>")}
            else:
                return_dict = {'msg':"En préparation"}
        else:
            return_dict = {'msg':"En préparation"}
        if "#FIN#" not in flag:
            return_dict = self._refresh_parse_call(return_dict)
        else:
            return_dict['message'] = "Importation terminée"
            unlink(LOG)
        return return_dict

    def _refresh_parse_call(self, return_dict):
        """
            Renvoie le script d'appel de rafraichissement de page
        """
        ajax_call = ajax.call(self.server_nb,
                              self.name,
                              run_importation='ok')
        return_dict['toexec'] = "setTimeout(\"%s\", %d);" % (ajax_call, 4000)
        return return_dict

    def _get_valid_btn(self):
        """ renvoie la description du bouton valider """
        validate_btn = {'href':tools.make_form_link(self.server_nb,
                                            self.name, True,
                                            ['synchro']),
                'title':"Lancer l'importation",
                'libelle':'Valider',
                'icone':'/image/ok.gif',}
        return validate_btn

