# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
fonctions communes pour la gestion des utilisateurs
"""
from ead2.backend.actions import tools
from ead2.backend.actions.lib.widgets import main as M
from scribe.linker import user_factory
from twisted.python import log

# liste des templates complémentaires utilisés
used_templates = ['main', 'form', 'formselect', 'accordion', 'listlist', 'checklist']

# liste des attributs pour l'adresse et le téléphone des responsables
# liste de tuples : (<attribut LDAP>, <libellé EAD>, <argument pour add()>)
ADRESSE = [('ENTPersonAdresse', 'Adresse', 'adresse'),
           ('ENTPersonCodePostal', 'Code postal', 'code'),
           ('ENTPersonVille', 'Ville', 'ville'),
           ('ENTPersonPays', 'Pays', 'pays'),
           ('homePhone', 'Téléphone fixe', 'telephone'),
           ('mobile', 'Téléphone portable', 'tel_portable'),
           ('telephoneNumber', 'Téléphone professionnel', 'tel_pro')]

def _get_menu(server_nb, current, _type=None):
    """
    renvoit la description du menu de gestion utilisateur
    :current: section en cours de traitement (ex: ajout utilisateur user_create)
    :_type: parametre de la section en cours de traitement (ex: pupil/teacher)
    """
    create_pupil = M.Bouton(href=tools.make_js_link(server_nb,
                                 'scribe_user_create', _type='pupil'),
                            libelle="Créer un<br/>élève",
                            icone='/image/scribe/eleve_create.gif',
                            title="Créer un compte élève")

    create_teacher = M.Bouton(href=tools.make_js_link(server_nb,
                                   'scribe_user_create', _type='teacher'),
                              libelle="Créer un professeur",
                              icone='/image/scribe/teacher_create.gif',
                              title="Créer un compte professeur")

    create_responsable = M.Bouton(href=tools.make_js_link(server_nb,
                                       'scribe_user_create', _type='responsable'),
                              libelle="Créer un responsable légal",
                              icone='/image/scribe/user_create.gif',
                              title="Créer un compte responsable légal")

    create_administratif = M.Bouton(href=tools.make_js_link(server_nb,
                                         'scribe_user_create', _type='administratif'),
                              libelle="Créer un administratif",
                              icone='/image/scribe/administratif_create.gif',
                              title="Créer un compte personnel administratif")

    create_other = M.Bouton(href=tools.make_js_link(server_nb,
                                 'scribe_user_create', _type='other'),
                            libelle="Créer un compte invité",
                            icone='/image/scribe/guest_create.gif',
                            title="Créer un compte invité")

    # pas de type pour l'action "listing"
    _list = M.Bouton(href=tools.make_js_link(server_nb, 'scribe_user_list'),
                     libelle="Lister des utilisateurs",
                     icone='/image/scribe/user_list.gif',
                     title="Lister des utilisateurs")

    # hack pour que le menu courant ne soit pas cliquable
    if current == 'scribe_user_create' and _type == 'pupil':
        create_pupil['href'] = ''
    elif current == 'scribe_user_create' and _type == 'teacher':
        create_teacher['href'] = ''
    elif current == 'scribe_user_list':
        _list['href'] = ''
    elif current == 'scribe_user_create' and _type == 'responsable':
        create_responsable['href'] = ''
    elif current == 'scribe_user_create' and _type == 'administratif':
        create_administratif['href'] = ''
    elif current == 'scribe_user_create' and _type == 'other':
        create_other['href'] = ''

    return dict(menus=[create_pupil, create_teacher, create_responsable,
                       create_administratif, create_other, _list])

def set_groups(user, new_grps, old_grps):
    """
    inscrit/desinscrit un utilisateur à des groupes
    :param user: login de l'utilisateur
    :param new_grps: groupes auxquels inscrire l'utilisateur
    :param old_grps: groupes desquels désinscrire l'utilisateur
    """
    if new_grps or old_grps:
        # utilisation de la factory pour obtenir la bonne classe
        ldapuser = user_factory(user)
        ldapuser.ldap_admin.connect()
        for grp in new_grps:
            log.msg("inscription de %s a %s" % (user, grp))
            ldapuser._inscription(user, grp, sync=False)
        for grp in old_grps:
            log.msg("desinscription de %s a %s" % (user, grp))
            ldapuser._desinscription(user, grp, sync=False)
        ldapuser._gen_ftpdir(user)
        ldapuser.ldap_admin.close()


def manage_groups(user, _type, ldapgroup, new_groups):
    """
    Gestion des inscriptions/desinscription d'un utilisateur
    à des groupes d'un type donné
    :param user: login utilisateur
    :param _type: type de groupe (au sens Eole)
    :param ldapgroup: instance de Group avec connecteur ldap
    :param new_groups: groupes auxquels doit être inscrit l'utilisateur
    """

    # doit être possible de le jouer en moins de coups
    # mais ce sera moins élégant ;)

    all_available_groups = set(ldapgroup._get_groups(_type))
    all_user_groups = set(ldapgroup._get_user_groups(user))

    old_user_groups = all_available_groups & all_user_groups
    old_available_groups = all_available_groups - all_user_groups

    new_user_groups = all_available_groups & set(new_groups)
    new_available_groups = all_available_groups - set(new_groups)

    inscription = (old_user_groups ^ new_user_groups) - old_user_groups
    desinscription = (old_available_groups ^ new_available_groups) - old_available_groups

    set_groups(user, list(inscription), list(desinscription))


def set_teacher_administration(user, datas, classes):
    """ enregistre un prof comme administrateur d'une classe
        :param user: login de l'utilisateur
        :param datas: données originales
        :param classes: classes administrés
    """
    old_user_admin_classes = set(datas.get('Divcod', []))
    new_user_admin_classes = set(classes)
    if old_user_admin_classes != new_user_admin_classes:
        ldapuser = user_factory(user)
        ldapuser.set_attr(user, 'Divcod', classes)
        # FIXME : c'est quand qu'on dégage le typeadmin ???
        if user != 'admin':
            if classes != []:
                ldapuser.set_attr(user, 'typeadmin', '2')
            else:
                ldapuser.set_attr(user, 'typeadmin', '0')


def set_managed_group(user, datas, managed_group):
    """
    :param user: login de l'utilisateur
    :param datas: données originales
    :param managed_group: groupes administrés
    """
    old_user_groups = set(datas.get('ManagedGroup', []))
    new_user_groupes = set(managed_group)
    if old_user_groups != new_user_groupes:
        ldapuser = user_factory(user)
        ldapuser.set_attr(user, 'ManagedGroup', managed_group)

