# -*- coding: utf-8 -*-
from twisted.web import resource, static
from ead2.backend.config.config import DOWNLOAD_DIR, MD5_DIR
import commands
from os import listdir
from os.path import isdir
from os.path import join
import md5
from twisted.python import log

class EadFile:
    """ assistant pour le telechargement de fichier"""
    def create_md5(self):
        log.msg("CREATING MD5")
        self.script_path = join(DOWNLOAD_DIR,'script')
        self.style_path = join(DOWNLOAD_DIR,'style')
        self.image_path = join(DOWNLOAD_DIR,'image')
        self.md5_script_path = join(MD5_DIR,'script')
        self.md5_style_path = join(MD5_DIR,'style')
        self.md5_image_path = join(MD5_DIR,'image')
        if isdir(self.script_path):
            scripts = listdir(self.script_path)
        else:
            scripts = []
        if isdir(self.style_path):
            styles = listdir(self.style_path)
        else:
            styles = []
        if isdir(self.image_path):
            images = listdir(self.image_path)
            images = self.clear_image_files(images)
        else:
            images = []
        code, message = self.create_dirs()
        if not code:
            print "erreur md5: ", message
            return
        self.create_md5_files(scripts, self.script_path, self.md5_script_path)
        self.create_md5_files(styles, self.style_path, self.md5_style_path)
        self.create_md5_files(images, self.image_path, self.md5_image_path)

    def create_dirs(self):
        """ cree les repertoires pour les fichiers md5 """
        if not isdir(MD5_DIR):
            code, retour = commands.getstatusoutput('mkdir %s'%MD5_DIR)
        else:
            code = 0
        if code == 0:
            if not isdir(self.md5_script_path):
                code, retour = commands.getstatusoutput('mkdir %s'%self.md5_script_path)
            else:
                code = 0
            if code == 0:
                if not isdir(self.md5_style_path):
                    code, retour = commands.getstatusoutput('mkdir %s'%self.md5_style_path)
                else:
                    code = 0
            if code == 0:
                if not isdir(self.md5_image_path):
                    code, retour = commands.getstatusoutput('mkdir %s'%self.md5_image_path)
                else:
                    code = 0
        else:
            return 2, "Erreur a la creation de dossier pour le md5"
        return 1, "Creation des dirs reussies"

    def create_md5_files(self,files,chemin1, chemin2):
        """ creation des fichiers md5 des fichiers de la liste :files: dans le dossier :chemin2:"""
        for fichier in files:
            fich = join(chemin1, fichier)
            if not isdir(fich):
                sum = md5.md5(file(fich,'rb').read()).hexdigest().strip()
                name = join(chemin2, fichier+'.md5')
                a = file(name, 'w')
                a.write(sum)
                a.close()

    def clear_image_files(self, images):
        result = []
        for f in images:
            ext = f[-3:]
            if ext.lower() in ['gif', 'jpg', 'png']:
                result.append(f)
        return result
