# -*- coding: utf-8 -*-
""" Page d'accueil de l'ead2 """
from nevow import loaders, tags as T, rend, inevow
from ead2.config.config import dico

class Accueil(rend.Fragment):
    """ accueil de l'ead
    """
    docFactory = loaders.xmlstr('''\
                   <div xmlns:nevow="http://nevow.com/ns/nevow/0.1">
                            <span nevow:render="main"/>
                    </div>
                            ''')

    def render_main(self, ctx, data):
        """ rend la partie centrale """
        session = inevow.ISession(ctx)
        tag = T.center[T.img(src="/image/logo-eole.png"),
                       T.br(), T.br(), T.br()]

        texte_tag = T.font(color='#000', size='4')[
                "Outil d'administration à distance de l'établissement :"]
        texte_tag.children.append(T.br())

        defaut = 'Établissement inconnu'
        nom_etab = dico.get('libelle_etab', defaut)
        if len(nom_etab) < 2:
            nom_etab = defaut
        nom_etab = nom_etab.capitalize()
        texte_tag.children.append(T.b()[nom_etab])
        texte_tag.children.extend([T.br(), T.br(), T.br(), T.br()])

        if session.magic_number is not None:
            texte_tag.children.append(T.b(style="text-transform:uppercase; color:#fd2345")[
                         T.img(src='/image/warning.png', style="vertical-align:middle"),
                         T.br(),
                         'UN UTILISATEUR EST CONNECTé'])
        else:
            texte_tag.children.append('Veuillez vous connecter au serveur de votre choix')
            texte_tag.children.append(T.br())
            texte_tag.children.append("en cliquant sur l'onglet correspondant")


        tag.children.append(texte_tag)
        return tag
