# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""Actions permettant de gérer les groupes """
from twisted.python import log
from ead2.lib.error import MissingKey, MissingValue
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.backend.actions.lib.widgets import main as M, form as F, ajax
from ead2.backend.actions.scribe.tool.group import (used_templates,
     _get_close_btn)
from scribe.eolegroup import Group
from scribe.eoletools import calc_recycle_dir

class GroupDelete(Action):
    """ Supprime un groupe """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'scribe_group_delete'
    libelle = "Supprimer un groupe"
    category = None
    description = 'Supprimer un groupe'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'group_name', 'del_group'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json",
                       keys=['group_deleting'])

    def execute(self):
        """ renvoit les données pour l'affichage
            1 - suppresion du groupe
                a - si partage, on renvoie un formulaire
                b - suppression du groupe
                c - on valide le formulaire et on supprime le groupe
        """
        params, self.server_nb = tools.get_request(self.request)
        result = {}
        if params.has_key('del_group'):
            if params.has_key('group_name'):
                todel = params['group_name'][0]
                ## 1 - a
                ldapgroup = Group()
                if ldapgroup.get_group_sharedirs(todel):
                    result.update(self._get_form(todel))
                ## 1 - b
                else:
                    try:
                        datas = self._remove_group(todel)
                    except (MissingKey, MissingValue, Exception), mess:
                        datas = {'message':mess.message}
                    # apres suppression on rafraichit la liste des groupes
                    href = ajax.valid(self.server_nb, 'scribe_group_list',
                                      ['list_group'],
                                      container='group_list_div_container')
                    href += "IncreaseOnly('user_listing_tool');"
                    href += "setVoid('user_div_container');"
                    href += "setVoid('mod_user_div_container');"
                    datas.update({'toexec':href})
                    return self.frag(datas)
        ## 1 - c
        if self.form_result != {}:
            try:
                datas = self._valid_form()
            except (MissingKey, MissingValue, Exception), mess:
                log.err("Erreur dans group.py : %s"%mess)
                log.err()
                datas = dict(message=mess.message)
            self.form_result = {}
            href = ajax.valid(self.server_nb, 'scribe_group_list',
                              ['list_group'],
                              container='group_list_div_container')
            href += "IncreaseOnly('user_listing_tool');"
            href += "setVoid('user_div_container');"
            href += "setVoid('mod_user_div_container');"
            datas.update({'toexec':href})
            return self.frag(datas)
        return self.send_all(result, template='scribe_group', templates=used_templates)

    def frag(self, datas):
        """ renvoie un fragment
            :datas: dictionnaire contenant les variables
             mise en forme par le template
        """
        return self.send_frag(datas, template='scribe_group',
                              templates=used_templates)

    def _get_form(self, todel):
        """ renvoie la decsription du formulaire de suppression de groupe """
        del_share_dirs = F.Checkbox(name='del_share_dirs',
                         libelle="Voulez-vous également supprimer les \
répertoires associés aux partages du groupe '%s' ?" % todel,
                         checked=True)
        todel = F.Input(name='group_todel', default=todel)
        return dict(del_share_dirs=del_share_dirs,
                        todel=todel,
                        validate=self._get_valid_btn(),
                        close_btn=_get_close_btn('mod_group_div_container'))

    def _get_valid_btn(self):
        """ renvoie la description du bouton valider """
        href = tools.make_form_link(self.server_nb, self.name, True,
                                    ['group_deleting'],
                                    balise='mod_group_div_container')
        return M.Submit(href=href, title="Supprimer le groupe")

    def _valid_form(self):
        """ valide le formulaire de suppression de groupe AVEC partage """
        if not self.form_result.has_key('group_deleting'):
            raise MissingKey, "Erreur : il manque des données pour la suppression de groupe."
        resultat = tools.format_form_result(self.form_result['group_deleting'],
                                            check=True)
        if resultat.keys() != ['del_share_dirs', 'group_todel']:
            raise MissingKey, "Erreur : il manque des données pour la suppression de groupe."
        todel = resultat['group_todel'].strip()
        del_share = resultat['del_share_dirs']
        ldapgroup = Group()
        ldapgroup.ldap_admin.connect()
        mail = ldapgroup._get_maillist(todel)
        ldapgroup._delete(todel, rmdir=del_share, sync=True)
        ldapgroup.ldap_admin.close()
        message = "Le groupe %s a été supprimé :\\n" % todel
        if mail:
            message += "- sa liste de diffusion a été supprimée\\n"
        if del_share:
            message += "- les répertoires de ses partages ont été supprimés"
        else:
            message += "- les répertoires de ses partages ont été déplacés vers\\n"
            message += "  %s" % calc_recycle_dir('workgroups')
        return dict(message=message)

    def _remove_group(self, todel):
        """ suppression d'un groupe sans partage """
        ldapgroup = Group()
        ldapgroup.ldap_admin.connect()
        message = "Le groupe %s a bien été supprimé" % todel
        if not ldapgroup._is_group(todel):
            raise MissingValue, "Erreur : le groupe %s n'existe pas." % todel
        if ldapgroup._get_maillist(todel):
            message += " ainsi que: \\n    - sa liste de diffusion"
        # suppression du groupe
        ldapgroup._delete(todel)
        ldapgroup.ldap_admin.close()
        return dict(message=message)

