# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action scribe_station
# suppression forcée d'une station du domaine
#
###########################################################################
from twisted.python import log
from scribe.station import Station as EoleStation
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions.lib.widgets import form as F, main as M
from ead2.backend.actions.tools import get_request, make_form_link, format_form_result
from ead2.lib.error import MissingKey, MissingValue

used_templates = ['main', 'formselect']

class Station(Action):
    """ Force la suppression d'une station du domaine """
    user_description = Dict(default={},
                            doc="description de l'éxécutant",
                            keys=['ip', 'name', 'role'])
    name = 'scribe_station'
    libelle = "Suppression de station"
    category = "Outils/Stations/"
    description = "Suppression forcée de station"
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action'])
    form_result = Dict(default={},
                       doc="Retour de formulaire en Json",
                       keys=['del_station'])

    def execute(self):
        """ renvoie les données pour l'affichage
            1 - renvoie d'un formulaire
            2 - suppression de la station
        """
        params, self.server_nb = get_request(self.request)
        result = {'titre':self.description,
                'sstitre':"Choisissez une station dont la suppression doit être forcée."}
        ## 2 -
        if self.form_result != {}:
            try:
                result.update(self._valid_form())
            except (MissingKey, MissingValue, Exception), mess:
                log.err("Erreur dans station.py : %s" % mess)
                result.update({'message':mess.message})
            self.form_result = {}
        ## 1 -
        result.update(self._get_form())
        return self.send_all(result, template='scribe_station',
                             templates=used_templates)

    def _get_form(self):
        """ renvoie la description du formulaire de suppression de station """
        station_select = F.Select(name='station_name',
                                  libelle='Nom de la station',
                                  inline=True)
        stations = EoleStation().get_workstations()
        for stat in stations:
            station_select.add_option(stat)
        return dict(station_select=station_select,
                    validate=self._get_validate_btn())

    def _valid_form(self):
        """ valide la suppression de station """
        if not self.form_result.has_key('del_station'):
            raise MissingKey, "Erreur : Il manque des données pour la suppression de station"
        resultat = format_form_result(self.form_result['del_station'])
        if not resultat.has_key('station_name'):
            raise MissingKey, "Erreur : Il manque des données pour la suppression de station"
        station_name = resultat['station_name'].strip()
        EoleStation().del_workstation(station_name)
        return dict(message="La station %s a bien été supprimée" % station_name)

    def _get_validate_btn(self):
        """ renvoie la description du bouton valider """
        href = make_form_link(self.server_nb, self.name, True, ['del_station'])
        return M.Submit(href=href, title="Supprimer la station")
