# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
librairie contenant des fonctions de validation
"""
from ead2.config.config import dico
from fichier.passwd import check_nb_min_classes

def test_password_length(pwd):
    """
    vérification de la taille d'un mot de passe
    """
    if not pwd:
        raise Exception, "Erreur : mot de passe vide."
    if len(pwd) < int(dico['smb_min_password_length']):
        raise Exception, "Erreur :\\nLe mot de passe doit comporter au moins %s caractères" % dico['smb_min_password_length']
    if not check_nb_min_classes(pwd, int(dico['smb_min_password_class'])):
        raise Exception, "Erreur :\\nLe mot de passe doit comporter au moins %s classes de caractères différentes" % dico['smb_min_password_class']

def test_confirm_passwd(pwd1, pwd2):
    """
    vérification d'un champ mot de passe
    et de sa confirmation
    """
    test_password_length(pwd1)
    if pwd1 != pwd2:
        raise Exception, "Erreur: les mots de passe ne concordent pas."
    else:
        return pwd1

def test_mailperso(mailperso):
    """
    vérification d'une adresse mail personalisée
    """
    mailperso = mailperso.strip()
    if mailperso == '':
        raise Exception, "Erreur : il manque l'adresse mail personnalisée."
    if '@' not in mailperso or '.' not in mailperso:
        raise Exception, "Erreur : l'adresse mail est invalide."
    return mailperso

