# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action navigation_visit
#
# Permet la consultation des logs par utilisateur, poste , horaire, url ou
# accès refusé
#
###########################################################################

""" Action de consultations des navigations web de la configuration admin sur un amon """

from twisted.python import log

from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.backend.actions.amon import visit_form
from ead2.backend.actions.amon.amon_tools import get_zone_libelle
from ead2.lib.error import MissingKey, MissingValue

# template additionnel
used_templates = ['main', 'form', 'formselect', 'accordion']
zone_libelle = get_zone_libelle(1)

class NavigationVisitadmin(Action):
    """ interface de gestion des visites de sites web"""
    user_description = Dict(default={},
                            doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'navigation_visit_admin'
    libelle = 'Visites des sites'
    description = "Observatoire des navigations sur '%s'" % (
                                        zone_libelle.lower(),)
    category = zone_libelle.capitalize()
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action',
                         'beg_filename', 'end_filename',
                         'beg', 'end',
                         'ip', 'login',
                         'size', 'page',
                         'url', 'denied'])

    form_result = Dict(default={},
                       doc="retour formulaire de la requete en cours coté frontend",
                       keys = ['log_request'])

    def execute(self):
        """ renvoie les données pour la mise en forme
            1 - renvoie la description du formulaire de consultation de log
            2 - valide le formulaire et renvoie les logs
            3 - repond aux requetes faites depuis un bouton (suivant, precedent, numéro de page)
        """
        params, self.server_nb = tools.get_request(self.request)
        ## 3 -
        if params.has_key('ip') or params.has_key('login') or params.has_key('page') or params.has_key('url'):
            try:
                datas = visit_form.get_page('admin', self.server_nb, self.name, params)
            except (MissingKey, MissingValue, Exception), mess:
                log.err()
                log.err("Erreur : navigation_visit.py, %s"%mess)
                datas = {'message':str(mess)}
            return self.send_frag(datas, template='amon_navigation_visit', templates=used_templates)
        ## 2 -
        if self.form_result.has_key('log_request'):
            try:
                result = tools.format_form_result(self.form_result['log_request'], True)
                datas = visit_form.valid_log_request('admin', self.server_nb, self.name, result)
            except (MissingKey, MissingValue, Exception), mess:
                log.err()
                log.err("Erreur : navigation_visit.py, %s"%mess)
                datas = {'message':str(mess)}
            self.form_result = {}
            return self.send_frag(datas, template='amon_navigation_visit', templates=used_templates)
        ## 1 -
        result = {'titre':self.description,
                  'sstitre1':"Choix du (des) jour(s)",
                  'sstitre2':"Critères de recherche"}
        result.update(visit_form.get_visit_form('admin'))
        result['validate'] = visit_form.get_validate_btn(self.server_nb, self.name)
        return self.send_all(result, template='amon_navigation_visit', templates=used_templates)
